#pragma once

#include <util/generic/string.h>

#include <vector>

namespace NPassport::NXml {
    class TConfig;
}

namespace NPassport::NXunistater::NCfgList {
    using TSignalXpath = TString;

    struct TTsvParser {
        TString Xpath;
        std::vector<TSignalXpath> Signals;
        std::vector<TSignalXpath> SignalTemplates;
    };

    struct TTskvParser {
        struct TConditionSet {
            TString Xpath;
            std::vector<TSignalXpath> Signals;
            std::vector<TSignalXpath> SignalTemplates;
        };

        TString Xpath;
        std::vector<TConditionSet> Conditions;
    };

    TTsvParser GetTsvParser(const NXml::TConfig& config, const TString& xpath);
    TTskvParser GetTskvParser(const NXml::TConfig& config, const TString& xpath);
    std::vector<TTsvParser> ListTsvParsers(const NXml::TConfig& config, const TString& xpath);
    std::vector<TTskvParser> ListTskvParsers(const NXml::TConfig& config, const TString& xpath);
}
