#pragma once

#include <passport/infra/daemons/xunistater/src/signal_template/signal_template.h>

namespace NPassport::NXml {
    class TConfig;
}

namespace NPassport::NXunistater::NCfg {
    NSt::TSignalTemplateCtx CreateSignalTemplateForTsv(const NXml::TConfig& config, const TString& xpath);
    NSt::TSignalTemplateCtx CreateSignalTemplateForTskv(const NXml::TConfig& config, const TString& xpath);

    using TFGCreator = std::function<NSt::TFieldGetter(const NXml::TConfig&, const TString&)>;

    NSt::TSignalTemplateCtx CreateSignalTemplate(const NXml::TConfig& config,
                                                 const TString& xpath,
                                                 TFGCreator fgCreatorName,
                                                 TFGCreator fgCreatorValue);

    NSt::TFieldGetter CreateFieldGetterTsvName(const NXml::TConfig& config, const TString& xpath);
    NSt::TFieldGetter CreateFieldGetterTskvName(const NXml::TConfig& config, const TString& xpath);

    NSt::TFieldGetter CreateFieldGetterTsvValue(const NXml::TConfig& config, const TString& xpath);
    NSt::TFieldGetter CreateFieldGetterTskvValue(const NXml::TConfig& config, const TString& xpath);

    NSt::TSignalFactoryPtr CreateFactory(const NXml::TConfig& config, const TString& xpath);
}
