#pragma once

#include <passport/infra/daemons/xunistater/src/parsers/tsv.h>
#include <passport/infra/daemons/xunistater/src/signal_providers/histogram.h>
#include <passport/infra/daemons/xunistater/src/signal_providers/substring.h>

namespace NPassport::NXml {
    class TConfig;
}

namespace NPassport::NXunistater::NCfg {
    using THgramSettings = TSignalHistogram::TSettings;
    struct TRegexSettings {
        TString Suffix;
        TString Regex;
    };
    struct TRpsSettings {
        TString Suffix;
    };
    using TSubstringSettings = TSignalSubstring::TSettings;
    struct TSumSettings {
        TString Suffix;
    };

    THgramSettings ParseHistogramSettings(const NXml::TConfig& config, const TString& xpath);
    TRegexSettings ParseRegexSettings(const NXml::TConfig& config, const TString& xpath);
    TRpsSettings ParseRpsSettings(const NXml::TConfig& config, const TString& xpath);
    TSubstringSettings ParseSubStringSettings(const NXml::TConfig& config, const TString& xpath);
    TSumSettings ParseSumSettings(const NXml::TConfig& config, const TString& xpath);

    TSignal InitSignalHistogram(const NXml::TConfig& config, const TString& xpath);
    TSignal InitSignalRegex(const NXml::TConfig& config, const TString& xpath);
    TSignal InitSignalRps(const NXml::TConfig& config, const TString& xpath);
    TSignal InitSignalStringSet(const NXml::TConfig& config, const TString& xpath);
    TSignal InitSignalSubString(const NXml::TConfig& config, const TString& xpath);
    TSignal InitSignalSum(const NXml::TConfig& config, const TString& xpath);

    NTsv::TColumnProcessor InitTsvSignalHistogram(const NXml::TConfig& config, const TString& xpath);
    NTsv::TColumnProcessor InitTsvSignalRegex(const NXml::TConfig& config, const TString& xpath);
    NTsv::TColumnProcessor InitTsvSignalRps(const NXml::TConfig& config, const TString& xpath);
    NTsv::TColumnProcessor InitTsvSignalStringSet(const NXml::TConfig& config, const TString& xpath);
    NTsv::TColumnProcessor InitTsvSignalSubString(const NXml::TConfig& config, const TString& xpath);
    NTsv::TColumnProcessor InitTsvSignalSum(const NXml::TConfig& config, const TString& xpath);
}
