#include "validator.h"

#include <passport/infra/libs/cpp/utils/log/global.h>
#include <passport/infra/libs/cpp/xml/config.h>
#include <passport/infra/libs/cpp/xml/schema.h>

#include <library/cpp/resource/resource.h>

namespace NPassport::NXunistater::NCfg {
    bool ValidateConfig(const NXml::TConfig& config) {
        const TString schema = NResource::Find("/builtin/schema");

        NXml::TConfig::TError err = config.CheckSchema(NXml::TDtdSchema(schema));
        if (err) {
            TLog::Warning() << "Soft schema validation failed for config: " << err;
            return false;
        }

        return true;
    }
}
