#pragma once

#include <passport/infra/libs/cpp/tail/tail.h>
#include <passport/infra/libs/cpp/unistat/builder.h>
#include <passport/infra/libs/cpp/utils/regular_task.h>

#include <util/stream/file.h>
#include <util/system/filemap.h>

namespace NPassport::NXunistater {
    class TParserBase {
    public:
        struct TBaseSettings {
            TString Filename;
            ui64 LinesBeforeFlush = 0;

            enum class EMissing {
                Ok,
                Fail,
            } MissingPolicy = EMissing::Fail;

            enum class EIgnoreParsingErrors {
                True,
                False,
            } IgnoreParsingErrors = EIgnoreParsingErrors::False;

            enum class EIgnoreProcessingErrors {
                True,
                False,
            } IgnoreProcessingErrors = EIgnoreProcessingErrors::False;
        };

        TParserBase(const TBaseSettings& settings);
        virtual ~TParserBase() = default;

        virtual void AddUnistat(NUnistat::TBuilder& builder) const = 0;

        virtual bool ProcessLine(TStringBuf line) = 0;
        virtual void Flush() = 0;

        ui64 GetErrors() const;

    protected:
        void Run();

        void LogError(TStringBuf valueId, TStringBuf line, TStringBuf err) const;
        void LogException(TStringBuf valueId, TStringBuf line, TStringBuf err) const;

    private:
        struct TFileDetails {
            std::unique_ptr<NTail::TTail> Input;
            ui64 Inode = 0;
        };

    private:
        static TFileDetails Openfile(const TString& filename, TBaseSettings::EMissing missingPolicy);
        static TFileDetails TryReopenfile(const TString& filename, TBaseSettings::EMissing missingPolicy, ui64 inode);

    protected:
        const TBaseSettings Settings_;

    private:
        mutable NUnistat::NBase::TSignalBufferedDiff<ui64> ParsingErrors_;
        TFileDetails File_;
    };
}
