#pragma once

#include "common_types.h"
#include "parser_base.h"
#include "tskv_condition.h"

#include <passport/infra/daemons/xunistater/src/signal_providers/base.h>
#include <passport/infra/daemons/xunistater/src/signal_template/signal_template.h>

#include <util/generic/hash.h>

#include <map>
#include <vector>

namespace NPassport::NXunistater::NTskv {
    struct TConditionSet {
        using TSignals = std::multimap<TString, TSignal>;

        NConds::TCondition Condition;
        TSignals Signals;
        NSt::TSignalsTemplates SignalTemplates;
    };

    using TConditions = std::vector<TConditionSet>;

    class TTskvParser: public TParserBase {
    public:
        struct TArgs {
            TConditions Conditions;
        };
        TTskvParser(const TBaseSettings& settings, TArgs&& args);

        void AddUnistat(NUnistat::TBuilder& builder) const override;

    protected:
        bool ProcessLine(TStringBuf line) override;
        void Flush() override;

    protected:
        static TErrorMsg ParseLine(TStringBuf line, TKeyValue& map, TString& buf);
        void ProccessCondition(const TKeyValue& values, TConditionSet& set, TStringBuf line) const;

    private:
        TConditions Conditions_;

        // Allocated memory
        TString Buf_;
        TKeyValue Map_;
    };

    using TParser = NUtils::TRegularTaskDecorator<TTskvParser>;
}
