#pragma once

#include "common_types.h"
#include "parser_base.h"

#include <passport/infra/daemons/xunistater/src/signal_providers/base.h>
#include <passport/infra/daemons/xunistater/src/signal_template/signal_template.h>

#include <passport/infra/libs/cpp/re2/regex.h>

namespace NPassport::NXunistater::NTsv {
    class TColumnGetter {
    public:
        TColumnGetter(std::optional<ui32> column);

        std::pair<TStringBuf, TErrorMsg> GetField(const TLine& lineVec, const TStringBuf lineStr) const;

        TStringBuf AsString() const {
            return Str_;
        }

    private:
        const std::optional<ui32> Column_;
        TString Str_;
    };

    struct TColumnProcessor {
        TColumnGetter Getter;
        TSignal Signal;
    };
    using TColumnProcessors = std::vector<TColumnProcessor>;

    class IParsingPolicy {
    public:
        virtual ~IParsingPolicy() = default;
        virtual bool ParseLine(TStringBuf lineStr, TLine& lineVec) const = 0;
    };
    using TParsingPolicy = std::unique_ptr<IParsingPolicy>;

    class TTsvParser: public TParserBase {
    public:
        struct TArgs {
            TColumnProcessors ColumnProcessors;
            TParsingPolicy Policy;
            NSt::TSignalsTemplates SignalTemplates;
        };
        TTsvParser(const TBaseSettings& settings, TArgs&& args);

        void AddUnistat(NUnistat::TBuilder& builder) const override;

        bool ProcessLine(TStringBuf line) override;
        void Flush() override;

    private:
        TColumnProcessors ColumnProcessors_;
        NSt::TSignalsTemplates SignalTemplates_;
        const TParsingPolicy Policy_;

        // Allocated memory
        TLine LineVec_;
    };

    using TParser = NUtils::TRegularTaskDecorator<TTsvParser>;

    class TSplittingPolicy: public IParsingPolicy {
    public:
        using TDelimeter = i8;

        TSplittingPolicy(TDelimeter delimeter);

        static TParsingPolicy Create(TDelimeter delimeter);

        bool ParseLine(TStringBuf lineStr, TLine& lineVec) const override;

    private:
        const char Delimeter_;
    };

    class TRegexingPolicy: public IParsingPolicy {
    public:
        TRegexingPolicy(const TString& regex);

        static TParsingPolicy Create(const TString& regex);

        bool ParseLine(TStringBuf lineStr, TLine& lineVec) const override;

    private:
        const NRe2::TRegexGroups Regex_;
        mutable NRe2::TRegexGroupsCtx RegexCtx_;
    };
}
