#pragma once

#include <passport/infra/libs/cpp/unistat/builder.h>

#include <util/generic/strbuf.h>
#include <util/generic/yexception.h>

#include <atomic>
#include <optional>
#include <vector>

namespace NPassport::NXunistater {
    using TErrorMsg = TString;

    static const inline TString DEFAULT_SUFFIX = "_dmmm";

    class ISignalProvider {
    public:
        virtual ~ISignalProvider() = default;

        virtual TErrorMsg Process(TStringBuf field) = 0;
        virtual void FlushBuffer() noexcept = 0;
        virtual void AddUnistat(NUnistat::TBuilder& builder) const = 0;

    public:
        TString SerializeForTest() const {
            TString res;
            NUnistat::TBuilder arr(res);
            AddUnistat(arr);
            return res;
        }
    };

    using TSignal = std::unique_ptr<ISignalProvider>;
}
