#pragma once

#include "base.h"

#include <passport/infra/libs/cpp/re2/regex.h>

#include <util/generic/yexception.h>

#include <optional>

namespace NPassport::NXunistater {
    class TSignalRegex: public ISignalProvider {
    public:
        TSignalRegex(const TString& name,
                     const TString& suffix,
                     const TString& regex)
            : Regex_(regex)
            , Data_(name, suffix)
        {
        }

        TErrorMsg Process(TStringBuf field) override {
            if (Regex_.PartialMatch(field)) {
                ++Data_;
            }

            return {};
        }

        void FlushBuffer() noexcept override {
            Data_.Flush();
        }

        void AddUnistat(NUnistat::TBuilder& builder) const override {
            builder.Add(Data_);
        }

    private:
        const NRe2::TRegex Regex_;
        NUnistat::TSignalBufferedDiff<> Data_;
    };
}
