#pragma once

#include "base.h"

namespace NPassport::NXunistater {
    class TSignalRps: public ISignalProvider {
    public:
        TSignalRps(const TString& name, const TString& suffix)
            : Data_(name, suffix)
        {
        }

        TErrorMsg Process(TStringBuf) override {
            ++Data_;
            return {};
        }

        void FlushBuffer() noexcept override {
            Data_.Flush();
        }

        void AddUnistat(NUnistat::TBuilder& builder) const override {
            builder.Add(Data_);
        }

    private:
        NUnistat::TSignalBufferedDiff<> Data_;
    };
}
