#pragma once

#include "base.h"

#include <util/generic/yexception.h>

#include <optional>

namespace NPassport::NXunistater {
    class TSignalSubstring: public ISignalProvider {
    public:
        enum class ECountOccurrences {
            True,
            False,
        };

        struct TSettings {
            TString Suffix;
            TString Value;
            ECountOccurrences CountOccurrences = ECountOccurrences::False;
        };

        TSignalSubstring(const TString& name,
                         const TSettings& settings)
            : Settings_(settings)
            , Data_(name, settings.Suffix)
        {
        }

        TErrorMsg Process(TStringBuf field) override {
            if (Settings_.CountOccurrences == ECountOccurrences::True) {
                size_t pos = field.find(Settings_.Value);
                while (TStringBuf::npos != pos) {
                    ++Data_;
                    pos = field.find(Settings_.Value, pos + Settings_.Value.size());
                }
            } else if (field.Contains(Settings_.Value)) {
                ++Data_;
            }

            return {};
        }

        void FlushBuffer() noexcept override {
            Data_.Flush();
        }

        void AddUnistat(NUnistat::TBuilder& builder) const override {
            builder.Add(Data_);
        }

    private:
        const TSettings Settings_;
        NUnistat::TSignalBufferedDiff<> Data_;
    };
}
