#pragma once

#include "base.h"

#include <util/generic/yexception.h>
#include <util/string/cast.h>

namespace NPassport::NXunistater {
    class TSignalSum: public ISignalProvider {
    public:
        TSignalSum(const TString& name, const TString& suffix)
            : Data_(name, suffix)
        {
        }

        TErrorMsg Process(TStringBuf field) override {
            double val = 0;
            if (!TryFromString(field, val)) {
                return TStringBuilder() << "sum: unexpected field format - is not double: '" << field << "'";
            }

            Data_ += val;
            return {};
        }

        void FlushBuffer() noexcept override {
            Data_.Flush();
        }

        void AddUnistat(NUnistat::TBuilder& builder) const override {
            builder.Add(Data_);
        }

    private:
        NUnistat::TSignalBufferedDiff<double> Data_;
    };
}
