#include "field_getter.h"

namespace NPassport::NXunistater::NSt {
    TFieldGetter::TFieldGetter(const TKvSettings& settings)
        : Kv_(settings)
    {
        Y_ENSURE(settings.From == TKvSettings::EFrom::Value,
                 "FieldGetter: supports only " << TKvSettings::EFrom::Value << ". got: " << settings.From);
        Y_ENSURE(settings.Key, "empty key is illegal");
    }

    TFieldGetter::TFieldGetter(const TArraySettings& settings)
        : Arr_(settings)
    {
    }

    TErrorableField TFieldGetter::Get(const NTskv::TKeyValue& kv) const {
        Y_VERIFY(Kv_);
        const TKvSettings& settings = *Kv_;

        auto it = kv.find(settings.Key);
        if (it == kv.end()) {
            return settings.Missingok
                       ? TErrorableField::CreateValue({}, settings.Missingok)
                       : TErrorableField::CreateError(TStringBuilder() << "key '" << settings.Key << "' is missing");
        }

        return TErrorableField::CreateValue(it->second, settings.Missingok);
    }

    TErrorableField TFieldGetter::Get(const NTsv::TLine& line) const {
        Y_VERIFY(Arr_);
        const TArraySettings& settings = *Arr_;

        if (settings.Column >= line.size()) {
            return TErrorableField::CreateError(TStringBuilder() << "column==" << (settings.Column + 1) << " is missing");
        }

        return TErrorableField::CreateValue(line[settings.Column]);
    }
}

template <>
void Out<NPassport::NXunistater::NSt::TErrorableField>(IOutputStream& o,
                                                       const NPassport::NXunistater::NSt::TErrorableField& val) {
    o << "value=" << val.Value << ";";
    o << "err=" << val.Err << ";";
}
