#pragma once

#include <passport/infra/daemons/xunistater/src/parsers/common_types.h>
#include <passport/infra/daemons/xunistater/src/signal_providers/base.h>

#include <util/generic/strbuf.h>
#include <util/generic/string.h>

#include <optional>

namespace NPassport::NXunistater::NSt {
    struct TErrorableField {
        static TErrorableField CreateValue(TStringBuf s, bool missingok = false) {
            return {s, {}, missingok};
        }

        static TErrorableField CreateError(TString s) {
            return {{}, std::move(s), false};
        }

        TStringBuf Value;
        TErrorMsg Err;
        bool Missingok = false;

        bool operator==(const TErrorableField& o) const {
            return Value == o.Value && Err == o.Err;
        }
    };

    class TFieldGetter {
    public:
        struct TKvSettings {
            enum class EFrom {
                Key,
                Value,
            } From = EFrom::Value;

            TString Key;
            bool Missingok = false;
        };
        TFieldGetter(const TKvSettings& settings);

        struct TArraySettings {
            ui32 Column = 0;
        };
        TFieldGetter(const TArraySettings& settings);

        TErrorableField Get(const NTskv::TKeyValue& kv) const;
        TErrorableField Get(const NTsv::TLine& line) const;

    private:
        std::optional<TKvSettings> Kv_;
        std::optional<TArraySettings> Arr_;
    };
}
