#include "name_builder.h"

namespace NPassport::NXunistater::NSt {
    TNameBuilder::TNameBuilder(std::vector<TTokenGetter> tokens, TStringBuf out)
        : Tokens_(std::move(tokens))
        , Pattern_(NRe2::TPattern::WithCustomPlaceholders(out, CreatePlaceholders(Tokens_)))
    {
        Y_ENSURE(!Tokens_.empty(), "do not use signal template without tokens: it is too expensive for trivial cases");
        Y_ENSURE(!Pattern_.IsEmpty(), "signal name cannot be empty");
        TmpTokens_.reserve(Tokens_.size());
    }

    std::vector<TString> TNameBuilder::BuildPersistent() const {
        return BuildWithPersistentImpl();
    }

    struct TValueSet {
        bool HasValue() const {
            return Pos_ < Values.size();
        }

        TStringBuf GetValue() {
            Y_VERIFY(HasValue());
            return Values[Pos_++];
        }

        void StartFromTheVeryBegining() {
            Pos_ = 0;
        }

        std::vector<TStringBuf> Values;

    private:
        size_t Pos_ = 0;
    };

    std::vector<TString> TNameBuilder::BuildWithPersistentImpl(const std::vector<TStringBuf>& curTokens) const {
        std::vector<TValueSet> vals;
        vals.reserve(Tokens_.size());

        size_t count = 1;

        for (const TTokenGetter& t : Tokens_) {
            TValueSet v;
            for (const TString& s : t.PersistentValues()) {
                v.Values.push_back(s);
            }
            count *= v.Values.size() + 1;

            vals.push_back(std::move(v));
        }

        if (!curTokens.empty()) {
            Y_VERIFY(curTokens.size() == Tokens_.size());
            for (size_t idx = 0; idx < vals.size(); ++idx) {
                vals[idx].Values.push_back(curTokens[idx]);
            }
        }

        std::vector<TString> res;
        res.reserve(count);

        TmpTokens_.clear();
        TmpTokens_.resize(vals.size());

        Add(vals, 0, res);

        return res;
    }

    void TNameBuilder::Add(const std::vector<TValueSet>& vals, size_t idx, std::vector<TString>& res) const {
        if (idx >= Tokens_.size()) {
            TString buf;
            Pattern_.BuildString(TmpTokens_, buf);
            res.push_back(std::move(buf));
            return;
        }

        for (TStringBuf v : vals.at(idx).Values) {
            TmpTokens_[idx] = v;
            Add(vals, idx + 1, res);
        }
    }

    NRe2::TPattern::TPlaceholders TNameBuilder::CreatePlaceholders(const std::vector<TTokenGetter>& tokens) {
        NRe2::TPattern::TPlaceholders res;
        for (const TTokenGetter& s : tokens) {
            Y_ENSURE(s.GetId(), "token id cannot be empty");
            res.push_back("{$" + s.GetId() + "}");
        }
        return res;
    }
}
