#pragma once

#include "token_getter.h"

#include <passport/infra/libs/cpp/re2/regex.h>

namespace NPassport::NXunistater::NSt {
    struct TValueSet;

    class TNameBuilder {
    public:
        TNameBuilder(std::vector<TTokenGetter> tokens, TStringBuf out);

        template <class Cont>
        TErrorableField Build(const Cont& cont) const {
            TmpTokens_.clear();
            for (const TTokenGetter& t : Tokens_) {
                TErrorableField res = t.Get(cont);
                if (res.Err) {
                    return TErrorableField::CreateError(
                        TStringBuilder() << "token='" << t.GetId() << "' failed to get string: " << res.Err);
                }
                TmpTokens_.push_back(res.Value);
            }

            Pattern_.BuildString(TmpTokens_, TmpBuf_);
            return TErrorableField::CreateValue(TmpBuf_);
        }

        template <class Cont>
        std::vector<TString> BuildWithPersistent(const Cont& cont) const {
            // Store all current tokens to tmpTokens_
            TErrorableField f = Build(cont);
            Y_VERIFY(f.Err.empty(), "Must be called only for fine cont: %s", f.Err.c_str());

            return BuildWithPersistentImpl(TmpTokens_);
        }

        std::vector<TString> BuildPersistent() const;

    private:
        std::vector<TString> BuildWithPersistentImpl(const std::vector<TStringBuf>& curTokens = {}) const;

        void Add(const std::vector<TValueSet>& vals, size_t idx, std::vector<TString>& res) const;

        static NRe2::TPattern::TPlaceholders CreatePlaceholders(const std::vector<TTokenGetter>& tokens);

    private:
        std::vector<TTokenGetter> Tokens_;
        NRe2::TPattern Pattern_;

        mutable std::vector<TStringBuf> TmpTokens_;
        mutable TString TmpBuf_;
    };
}
