#include "signal_template.h"

namespace NPassport::NXunistater::NSt {
    TSignalTemplate::TSignalTemplate(TNameBuilder nb, TFieldGetter valueGetter, TSignalFactoryPtr factory)
        : NameBuilder_(std::move(nb))
        , ValueGetter_(std::move(valueGetter))
        , Factory_(std::move(factory))
    {
        AddPersistNames(NameBuilder_.BuildPersistent());
        FlushBuffer();
    }

    void TSignalTemplate::FlushBuffer() noexcept {
        try {
            if (!Buffer_.Signals.empty()) {
                std::unique_lock lock(Data_.Mutex);
                Data_.Signals.insert(Data_.Signals.end(), Buffer_.Signals.begin(), Buffer_.Signals.end());
            }
            Buffer_.Signals.clear();
        } catch (const std::exception& e) {
            TLog::Debug() << "SignalTemplate: failed to FlushBuffer(): " << e.what();
        }

        for (ISignalProvider* s : Data_.Signals) {
            s->FlushBuffer();
        }
    }

    void TSignalTemplate::AddUnistat(NUnistat::TBuilder& builder) const {
        std::unique_lock lock(Data_.Mutex);
        for (const ISignalProvider* s : Data_.Signals) {
            s->AddUnistat(builder);
        }
    }

    void TSignalTemplate::AddPersistNames(const std::vector<TString>& names) {
        for (const TString& str : names) {
            if (Buffer_.Instances.contains(str)) {
                continue;
            }

            TSignal signal = Factory_->Create(str);

            Buffer_.Signals.push_back(signal.get());
            Buffer_.Instances.emplace(str, std::move(signal));
        }
    }
}
