#pragma once

#include "field_getter.h"
#include "name_builder.h"
#include "signal_factory.h"

#include <passport/infra/libs/cpp/json/writer.h>

#include <mutex>

namespace NPassport::NXunistater::NSt {
    class TSignalTemplate {
    public:
        TSignalTemplate(TNameBuilder nb, TFieldGetter valueGetter, TSignalFactoryPtr factory);

        template <class Cont>
        TErrorMsg Process(const Cont& cont) {
            TErrorableField name = NameBuilder_.Build(cont);
            if (name.Err) {
                return TStringBuilder() << "failed to get name for signal template: " << name.Err;
            }

            TErrorableField value = ValueGetter_.Get(cont);
            if (value.Err) {
                return TStringBuilder() << "failed to get value for signal template: " << value.Err;
            }

            auto it = Buffer_.Instances.find(name.Value);

            if (it == Buffer_.Instances.end()) {
                AddPersistNames(NameBuilder_.BuildWithPersistent(cont));

                it = Buffer_.Instances.find(name.Value);
                Y_VERIFY(it != Buffer_.Instances.end());
            }

            return it->second->Process(value.Value);
        }

        void FlushBuffer() noexcept;

        void AddUnistat(NUnistat::TBuilder& builder) const;

    private:
        void AddPersistNames(const std::vector<TString>& names);

    private:
        TNameBuilder NameBuilder_;
        TFieldGetter ValueGetter_;
        TSignalFactoryPtr Factory_;

        struct TBuffer {
            THashMap<TString, TSignal> Instances;
            std::vector<ISignalProvider*> Signals;
        } Buffer_;

        struct TData {
            std::vector<ISignalProvider*> Signals;
            mutable std::mutex Mutex;
        } Data_;
    };

    using TSignalTemplatePtr = std::unique_ptr<TSignalTemplate>;

    struct TSignalTemplateCtx {
        TSignalTemplatePtr Templ;

        enum class EIgnoreErrors {
            True,
            False,
        } IgnoreErrors = EIgnoreErrors::False;
    };
    using TSignalsTemplates = std::vector<TSignalTemplateCtx>;
}
