#include "token_getter.h"

namespace NPassport::NXunistater::NSt {
    TTokenGetter::TFuncPtr TTokenGetter::TFuncAsIs::Create() {
        return std::make_unique<TFuncAsIs>();
    }

    TErrorableField TTokenGetter::TFuncAsIs::Apply(TStringBuf field) {
        return TErrorableField::CreateValue(field);
    }

    TTokenGetter::TFuncRegexGroup::TFuncRegexGroup(TStringBuf in, TStringBuf out)
        : Regex_(in, out)
    {
    }

    TTokenGetter::TFuncPtr TTokenGetter::TFuncRegexGroup::Create(TStringBuf in, TStringBuf out) {
        return std::make_unique<TFuncRegexGroup>(in, out);
    }

    static const TString ERR = "func='regex_group' mismatched";
    TErrorableField TTokenGetter::TFuncRegexGroup::Apply(TStringBuf field) {
        return Regex_.Apply(Ctx_, Groups_, field, Buf_)
                   ? TErrorableField::CreateValue(Buf_)
                   : TErrorableField::CreateError(ERR);
    }

    TTokenGetter::TTokenGetter(TArgs args)
        : Args_(std::move(args))
    {
    }

    TErrorableField TTokenGetter::GetImpl(TErrorableField&& res) const {
        if (res.Err) {
            return std::move(res);
        }

        auto post = [this](TErrorableField&& res) {
            for (const TTokenPostProcessor& t : Args_.PostProcs) {
                res.Value = t->Apply(res.Value);
            }
            return std::move(res);
        };

        if (!res.Value && res.Missingok) {
            return post(std::move(res));
        }

        return post(Args_.Func->Apply(res.Value));
    }
}
