#pragma once

#include "field_getter.h"
#include "token_postprocessor.h"

#include <passport/infra/libs/cpp/re2/regex.h>

namespace NPassport::NXunistater::NSt {
    class TTokenGetter {
    public:
        class IFunc {
        public:
            virtual ~IFunc() = default;
            virtual TErrorableField Apply(TStringBuf field) = 0;
        };
        using TFuncPtr = std::unique_ptr<IFunc>;

        class TFuncAsIs: public IFunc {
        public:
            static TFuncPtr Create();
            TErrorableField Apply(TStringBuf field) override;
        };

        class TFuncRegexGroup: public IFunc {
        public:
            TFuncRegexGroup(TStringBuf in, TStringBuf out);

            static TFuncPtr Create(TStringBuf in, TStringBuf out);

            TErrorableField Apply(TStringBuf field) override;

        private:
            const NRe2::TReplacingRegex Regex_;

            // allocated memory
            NRe2::TRegexGroupsCtx Ctx_;
            TSmallVec<TStringBuf> Groups_;
            TString Buf_;
        };

    public:
        struct TArgs {
            TFieldGetter Getter;
            TFuncPtr Func;
            TString Id;
            TTokenPostProcessors PostProcs;
            std::vector<TString> PersistentValues;
        };

        TTokenGetter(TArgs args);

        const TString& GetId() const {
            return Args_.Id;
        }

        template <class Cont>
        TErrorableField Get(const Cont& cont) const {
            return GetImpl(Args_.Getter.Get(cont));
        }

        const std::vector<TString>& PersistentValues() const {
            return Args_.PersistentValues;
        }

    private:
        TErrorableField GetImpl(TErrorableField&& res) const;

    private:
        TArgs Args_;
    };
}
