#include "token_postprocessor.h"

namespace NPassport::NXunistater::NSt {
    TTokenPostProcMap::TTokenPostProcMap(TTokenPostProcMap::TMap&& map, std::optional<TString> defaultValue)
        : Map_(std::move(map))
        , DefaultValue_(std::move(defaultValue))
    {
    }

    TTokenPostProcessor TTokenPostProcMap::Create(TTokenPostProcMap::TMap&& map, std::optional<TString> defaultValue) {
        return std::make_unique<TTokenPostProcMap>(std::move(map), std::move(defaultValue));
    }

    TStringBuf TTokenPostProcMap::Apply(TStringBuf value) const {
        auto it = Map_.find(value);
        if (it != Map_.end()) {
            return it->second;
        }

        return DefaultValue_ ? *DefaultValue_ : value;
    }
}
