#pragma once

#include <util/generic/hash.h>
#include <util/generic/strbuf.h>

#include <optional>
#include <vector>

namespace NPassport::NXunistater::NSt {
    class ITokenPostProcessor {
    public:
        virtual ~ITokenPostProcessor() = default;

        virtual TStringBuf Apply(TStringBuf value) const = 0;
    };
    using TTokenPostProcessor = std::unique_ptr<ITokenPostProcessor>;

    class TTokenPostProcMap: public ITokenPostProcessor {
    public:
        using TMap = THashMap<TString, TString>;

        TTokenPostProcMap(TMap&& map, std::optional<TString> defaultValue);

        static TTokenPostProcessor Create(TMap&& map, std::optional<TString> defaultValue);

        TStringBuf Apply(TStringBuf value) const override;

    private:
        const TMap Map_;
        const std::optional<TString> DefaultValue_;
    };

    using TTokenPostProcessors = std::vector<TTokenPostProcessor>;
}
