#include "request_parser.h"

#include "mem_storage.h"

#include <passport/infra/libs/cpp/json/reader.h>

#include <util/generic/yexception.h>

namespace NPassport::NXunistater {
    void TRequestParser::Parse(TMemStorage& storage, TStringBuf body) {
        rapidjson::Document doc;

        Y_ENSURE(NJson::TReader::DocumentAsObject(body, doc),
                 "invalid json object: '" << body << "'");

        for (auto it = doc.MemberBegin(); it != doc.MemberEnd(); ++it) {
            TStringBuf key(it->name.GetString(), it->name.GetStringLength());

            double val;
            Y_ENSURE(NJson::TReader::MemberAsDouble(it->value, "value", val),
                     "required '/" << key << "/value' as double: '" << body << "'");

            storage.AddValue(key, val);
        }
    }
}
