#pragma once

#include "parsers/parser_base.h"
#include "storage/mem_storage.h"

#include <passport/infra/libs/cpp/request/request.h>

#include <util/generic/hash.h>

#include <atomic>
#include <memory>

namespace NPassport::NXml {
    class TConfig;
}

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NXunistater::NCfgList {
    struct TTsvParser;
    struct TTskvParser;
}

namespace NPassport::NXunistater {
    enum class EShowErrorSignal {
        True,
        False,
    };

    class TXunistater {
    public:
        TXunistater();
        ~TXunistater();

        void Init(const NXml::TConfig& config);

        void HandleRequest(NCommon::TRequest& req);

        void AddUnistat(NUnistat::TBuilder& builder);

    private:
        void ChooseMethod(NCommon::TRequest& req);
        void HandleMethodGet(NCommon::TRequest& req) const;
        void HandleMethodPost(NCommon::TRequest& req);

        TString HandleSignals(const TStringBuf path) const;

        static std::pair<TString, bool> HandleMemStorage(TMemStorage& storage, const TStringBuf body);

        static void InitLogger(const NXml::TConfig& config, const TString& xpath);
        void InitMiscOptions(const NXml::TConfig& config, const TString& xpath);

        void InitParsers(const NXml::TConfig& config, const TString& xpath);
        void InitStorages(const NXml::TConfig& config, const TString& xpath);

        static std::unique_ptr<TParserBase> InitTsvParser(const NXml::TConfig& config,
                                                          const NCfgList::TTsvParser& xpath);
        static std::unique_ptr<TParserBase> InitTskvParser(const NXml::TConfig& config,
                                                           const NCfgList::TTskvParser& xpath);

        void CheckUniqueHttpPath(const TString& httpPath) const;
        static EShowErrorSignal ShowErrorSignal(const NXml::TConfig& config, const TString& xpath);

    private:
        bool AreHttpPathesUnique_ = true;

        std::atomic_bool InitFailed_ = true;

        template <typename T>
        struct TSignals {
            std::unique_ptr<T> Signals;
            EShowErrorSignal ShowErrors = EShowErrorSignal::True;
        };

        // must be last
        THashMultiMap<TString, TSignals<TParserBase>> Parsers_;
        THashMap<TString, TSignals<TMemStorage>> Storages_;
    };
}
