LIBRARY()

OWNER(g:passport_infra)

PEERDIR(
    library/cpp/resource
    library/cpp/string_utils/tskv_format
    passport/infra/libs/cpp/xml
    passport/infra/libs/cpp/re2
    passport/infra/libs/cpp/tail
    passport/infra/libs/cpp/unistat
    passport/infra/libs/cpp/utils
)

SRCS(
    config/common.cpp
    config/list.cpp
    config/parsers.cpp
    config/signals.cpp
    config/signal_templates.cpp
    config/validator.cpp
    parsers/parser_base.cpp
    parsers/tskv_condition.cpp
    parsers/tskv.cpp
    parsers/tsv.cpp
    signal_template/field_getter.cpp
    signal_template/name_builder.cpp
    signal_template/signal_template.cpp
    signal_template/token_getter.cpp
    signal_template/token_postprocessor.cpp
    storage/mem_storage.cpp
    storage/request_parser.cpp
    storage/serializer.cpp
    xunistater.cpp
)

RESOURCE(
    config/schema.dtd /builtin/schema
)

GENERATE_ENUM_SERIALIZATION(parsers/tskv_condition.h)
GENERATE_ENUM_SERIALIZATION(signal_template/field_getter.h)
GENERATE_ENUM_SERIALIZATION(storage/mem_storage.h)

END()
