#pragma once

#include <passport/infra/libs/cpp/unistat/builder.h>

#include <util/system/event.h>

#include <atomic>
#include <thread>

template <class T>
TString SerializeForTest(T& s) {
    TString res;
    NPassport::NUnistat::TBuilder arr(res);
    s.AddUnistat(arr);
    return res;
}

// checks thread-safety of signal providers
class TAutoUnistater {
public:
    template <class T>
    TAutoUnistater(T& s) {
        TAutoEvent ev;
        Thread_ = std::thread(([this, &s, &ev]() {
            ev.Signal();
            while (!Stop_) {
                SerializeForTest(s);
            }
        }));
        ev.Wait();
    }

    ~TAutoUnistater() {
        Stop_ = true;
        Thread_.join();
    }

private:
    std::atomic_bool Stop_ = {false};
    std::thread Thread_;
};
