#include <passport/infra/daemons/xunistater/src/config/common.h>

#include <passport/infra/libs/cpp/xml/config.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NXunistater::NCfg;

Y_UNIT_TEST_SUITE(Config) {
    Y_UNIT_TEST(pretty) {
        const NXml::TConfig cfg = NXml::TConfig::ReadFromMemory(R"(
<doc>
<lonely1/>
<item>num1</item>
<item id="lol">num2</item>
<item id="kek">num3</item>
<item>num4</item>
<not_unique_item id="lol"/>
<not_unique_item id="lol"/>
</doc>
)");
        UNIT_ASSERT_VALUES_EQUAL("/doc/lonely1", PrettifyXpath(cfg, "/doc/lonely1"));
        UNIT_ASSERT_VALUES_EQUAL("/doc/lonely1[1]", PrettifyXpath(cfg, "/doc/lonely1[1]"));

        UNIT_ASSERT_VALUES_EQUAL("/doc/item[@id='lol']", PrettifyXpath(cfg, "/doc/item[@id='lol']"));

        UNIT_ASSERT_VALUES_EQUAL("/doc/item[1]", PrettifyXpath(cfg, "/doc/item[1]"));
        UNIT_ASSERT_VALUES_EQUAL("/doc/item[@id='lol']", PrettifyXpath(cfg, "/doc/item"));

        UNIT_ASSERT_VALUES_EQUAL("/doc/not_unique_item[@id='lol']", PrettifyXpath(cfg, "/doc/not_unique_item"));

        UNIT_ASSERT_VALUES_EQUAL(std::vector<TString>({
                                     "/doc/item[1]",
                                     "/doc/item[@id='lol']",
                                     "/doc/item[@id='kek']",
                                     "/doc/item[4]",
                                 }),
                                 GetPrettyXpathSubkeys(cfg, "/doc/item"));

        std::vector<TString> arr = GetPrettyXpathSubkeys(cfg, "/doc/item");
        for (size_t idx = 0; idx < arr.size(); ++idx) {
            UNIT_ASSERT_VALUES_EQUAL("num" + IntToString<10>(idx + 1), cfg.AsString(arr[idx]));
        }

        UNIT_ASSERT_EXCEPTION_CONTAINS(GetPrettyXpathSubkeys(cfg, "/doc/not_unique_item"),
                                       yexception,
                                       "id is not unique: /doc/not_unique_item[@id='lol']");
    }
}
