#include <passport/infra/daemons/xunistater/ut/auto_uninstater.h>

#include <passport/infra/daemons/xunistater/src/signal_providers/histogram.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NXunistater;

Y_UNIT_TEST_SUITE(Histogram) {
    Y_UNIT_TEST(line) {
        TSignalHistogram signal("ololo", {{2, 3, 5, 10}, TSignalHistogram::EAllowManyValues::False});
        TAutoUnistater au(signal);

        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",[[0,0],[2,0],[3,0],[5,0],[10,0]]]])", signal.SerializeForTest());

        UNIT_ASSERT_STRINGS_EQUAL("hgram: unexpected field format - is not double 'kek'", signal.Process("kek"));

        for (int i = 0; i < 256; ++i) {
            UNIT_ASSERT_STRINGS_EQUAL("", signal.Process("0.000"));
        }
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",[[0,0],[2,0],[3,0],[5,0],[10,0]]]])", signal.SerializeForTest());

        signal.FlushBuffer();
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",[[0,256],[2,0],[3,0],[5,0],[10,0]]]])", signal.SerializeForTest());

        for (int i = 0; i < 256; ++i) {
            UNIT_ASSERT_STRINGS_EQUAL("", signal.Process("0.001"));
            UNIT_ASSERT_STRINGS_EQUAL("", signal.Process("0.005"));
        }

        signal.FlushBuffer();
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",[[0,512],[2,0],[3,0],[5,256],[10,0]]]])", signal.SerializeForTest());

        signal.FlushBuffer();
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",[[0,512],[2,0],[3,0],[5,256],[10,0]]]])", signal.SerializeForTest());

        for (int i = 0; i < 3; ++i) {
            UNIT_ASSERT_STRINGS_EQUAL("", signal.Process("1.001"));
        }
        signal.FlushBuffer();
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",[[0,512],[2,0],[3,0],[5,256],[10,3]]]])", signal.SerializeForTest());

        for (int i = 0; i < 5; ++i) {
            UNIT_ASSERT_STRINGS_EQUAL("", signal.Process("-"));
        }
        signal.FlushBuffer();
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",[[0,512],[2,0],[3,0],[5,256],[10,3]]]])", signal.SerializeForTest());
    }

    Y_UNIT_TEST(fieldToValue) {
        class TTestSignal: public TSignalHistogram {
        public:
            using TSignalHistogram::TSignalHistogram;

            using TSignalHistogram::FieldToValue;
        };

        TTestSignal signal("ololo", {{2, 3, 5, 10}, TSignalHistogram::EAllowManyValues::False, 100});
        std::pair<ui64, TErrorMsg> val;
        TAutoUnistater au(signal);

        val = signal.FieldToValue("");
        UNIT_ASSERT_VALUES_EQUAL("hgram: unexpected field format - is not double ''", val.second);
        UNIT_ASSERT_VALUES_EQUAL(val.first, 0);

        val = signal.FieldToValue("0");
        UNIT_ASSERT_VALUES_EQUAL("", val.second);
        UNIT_ASSERT_VALUES_EQUAL(val.first, 0);

        val = signal.FieldToValue("0.0");
        UNIT_ASSERT_VALUES_EQUAL("", val.second);
        UNIT_ASSERT_VALUES_EQUAL(val.first, 0);

        val = signal.FieldToValue("1.0");
        UNIT_ASSERT_VALUES_EQUAL("", val.second);
        UNIT_ASSERT_VALUES_EQUAL(val.first, 100);

        val = signal.FieldToValue("100.");
        UNIT_ASSERT_VALUES_EQUAL("", val.second);
        UNIT_ASSERT_VALUES_EQUAL(val.first, 10000);

        val = signal.FieldToValue("4500000000.");
        UNIT_ASSERT_VALUES_EQUAL("", val.second);
        UNIT_ASSERT_VALUES_EQUAL(val.first, 450000000000);

        val = signal.FieldToValue(".100");
        UNIT_ASSERT_VALUES_EQUAL("", val.second);
        UNIT_ASSERT_VALUES_EQUAL(val.first, 10);

        val = signal.FieldToValue("100.5.1");
        UNIT_ASSERT_VALUES_EQUAL("hgram: unexpected field format - is not double '100.5.1'", val.second);
        UNIT_ASSERT_VALUES_EQUAL(val.first, 0);

        val = signal.FieldToValue("-");
        UNIT_ASSERT_VALUES_EQUAL("", val.second);
        UNIT_ASSERT_VALUES_EQUAL(val.first, 0);
    }

    Y_UNIT_TEST(manyFieldsToValue) {
        class TTestSignal: public TSignalHistogram {
        public:
            using TSignalHistogram::TSignalHistogram;

            using TSignalHistogram::ManyFieldsToValue;
        };

        TTestSignal signal("ololo", {{2, 3, 5, 10}, TSignalHistogram::EAllowManyValues::False});
        std::pair<ui32, TErrorMsg> val;
        TAutoUnistater au(signal);

        val = signal.ManyFieldsToValue("");
        UNIT_ASSERT_VALUES_EQUAL("hgram: field is empty", val.second);
        UNIT_ASSERT_VALUES_EQUAL(val.first, 0);

        val = signal.ManyFieldsToValue("0");
        UNIT_ASSERT_VALUES_EQUAL("", val.second);
        UNIT_ASSERT_VALUES_EQUAL(val.first, 0);

        val = signal.ManyFieldsToValue("0.100, ");
        UNIT_ASSERT_VALUES_EQUAL("", val.second);
        UNIT_ASSERT_VALUES_EQUAL(val.first, 100);

        val = signal.ManyFieldsToValue("0.100, 1.000, 0.000, 0.050");
        UNIT_ASSERT_VALUES_EQUAL("", val.second);
        UNIT_ASSERT_VALUES_EQUAL(val.first, 1150);

        val = signal.ManyFieldsToValue("0.100, 1.000 : 0.30, 0.000, 0.050");
        UNIT_ASSERT_VALUES_EQUAL("", val.second);
        UNIT_ASSERT_VALUES_EQUAL(val.first, 1450);

        val = signal.ManyFieldsToValue("100.5.1");
        UNIT_ASSERT_VALUES_EQUAL("hgram: unexpected field format - is not double '100.5.1'", val.second);
        UNIT_ASSERT_VALUES_EQUAL(val.first, 0);
    }
}
