#include <passport/infra/daemons/xunistater/ut/auto_uninstater.h>

#include <passport/infra/daemons/xunistater/src/signal_providers/regex.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NXunistater;

Y_UNIT_TEST_SUITE(Regex) {
    Y_UNIT_TEST(line) {
        TSignalRegex signal("ololo", "_dhhh", R"(5\d\d)");
        TAutoUnistater au(signal);

        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",0]])", signal.SerializeForTest());

        UNIT_ASSERT_STRINGS_EQUAL("", signal.Process("kek"));

        for (int i = 0; i < 256; ++i) {
            UNIT_ASSERT_STRINGS_EQUAL("", signal.Process(R"("504")"));
        }
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",0]])", signal.SerializeForTest());

        signal.FlushBuffer();
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",256]])", signal.SerializeForTest());

        for (int i = 0; i < 4; ++i) {
            UNIT_ASSERT_STRINGS_EQUAL("", signal.Process("her.509"));
            UNIT_ASSERT_STRINGS_EQUAL("", signal.Process("ko"));
        }

        signal.FlushBuffer();
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",260]])", signal.SerializeForTest());

        signal.FlushBuffer();
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",260]])", signal.SerializeForTest());
    }

    Y_UNIT_TEST(optional) {
        TSignalRegex signal("ololo", "dhhh", R"(5\d\d)");
        TAutoUnistater au(signal);

        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",0]])", signal.SerializeForTest());

        UNIT_ASSERT_STRINGS_EQUAL("", signal.Process("kek"));
        UNIT_ASSERT_STRINGS_EQUAL("", signal.Process(""));

        for (int i = 0; i < 256; ++i) {
            UNIT_ASSERT_STRINGS_EQUAL("", signal.Process(R"(2018-01-01 "504" 100500)"));
        }
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",0]])", signal.SerializeForTest());

        signal.FlushBuffer();
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",256]])", signal.SerializeForTest());

        for (int i = 0; i < 4; ++i) {
            UNIT_ASSERT_STRINGS_EQUAL("", signal.Process(R"(2018-01-01 her.509 10050)"));
            UNIT_ASSERT_STRINGS_EQUAL("", signal.Process(R"(2018-01-01 ko" 10050)"));
        }

        signal.FlushBuffer();
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",260]])", signal.SerializeForTest());

        signal.FlushBuffer();
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",260]])", signal.SerializeForTest());
    }
}
