#include <passport/infra/daemons/xunistater/ut/auto_uninstater.h>

#include <passport/infra/daemons/xunistater/src/signal_providers/rps.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NXunistater;

Y_UNIT_TEST_SUITE(Rps) {
    Y_UNIT_TEST(line) {
        TSignalRps signal("ololo", "dhhh");
        TAutoUnistater au(signal);

        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",0]])", signal.SerializeForTest());

        for (int i = 0; i < 256; ++i) {
            UNIT_ASSERT_VALUES_EQUAL("", signal.Process(""));
        }
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",0]])", signal.SerializeForTest());

        signal.FlushBuffer();
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",256]])", signal.SerializeForTest());

        signal.FlushBuffer();
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",256]])", signal.SerializeForTest());
    }
}
