#include <passport/infra/daemons/xunistater/ut/auto_uninstater.h>

#include <passport/infra/daemons/xunistater/src/signal_providers/substring.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NXunistater;

Y_UNIT_TEST_SUITE(SubString) {
    Y_UNIT_TEST(line) {
        TSignalSubstring signal("ololo", {"dhhh", "ko", TSignalSubstring ::ECountOccurrences::False});
        TAutoUnistater au(signal);

        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",0]])", signal.SerializeForTest());

        UNIT_ASSERT_STRINGS_EQUAL("", signal.Process("kek"));

        for (int i = 0; i < 256; ++i) {
            UNIT_ASSERT_STRINGS_EQUAL("", signal.Process("my_kokoko.ru"));
        }
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",0]])", signal.SerializeForTest());

        signal.FlushBuffer();
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",256]])", signal.SerializeForTest());

        for (int i = 0; i < 256; ++i) {
            UNIT_ASSERT_STRINGS_EQUAL("", signal.Process("her.kokoko"));
            UNIT_ASSERT_STRINGS_EQUAL("", signal.Process("ok"));
        }

        signal.FlushBuffer();
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",512]])", signal.SerializeForTest());

        signal.FlushBuffer();
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",512]])", signal.SerializeForTest());
    }

    Y_UNIT_TEST(countOccurrences) {
        TSignalSubstring signal("ololo", {"dhhh", "aa", TSignalSubstring ::ECountOccurrences::True});
        TAutoUnistater au(signal);

        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",0]])", signal.SerializeForTest());

        UNIT_ASSERT_STRINGS_EQUAL("", signal.Process("kek"));

        for (int i = 0; i < 256; ++i) {
            UNIT_ASSERT_STRINGS_EQUAL("", signal.Process("my_aaaaa.ru"));
        }
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",0]])", signal.SerializeForTest());

        signal.FlushBuffer();
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",512]])", signal.SerializeForTest());

        for (int i = 0; i < 256; ++i) {
            UNIT_ASSERT_STRINGS_EQUAL("", signal.Process("her.aaaaa"));
            UNIT_ASSERT_STRINGS_EQUAL("", signal.Process("ok"));
        }

        signal.FlushBuffer();
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",1024]])", signal.SerializeForTest());

        signal.FlushBuffer();
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",1024]])", signal.SerializeForTest());
    }

    Y_UNIT_TEST(optional) {
        TSignalSubstring signal("ololo", {"dhhh", "kokoko", TSignalSubstring ::ECountOccurrences::False});
        TAutoUnistater au(signal);

        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",0]])", signal.SerializeForTest());

        UNIT_ASSERT_STRINGS_EQUAL("", signal.Process("kek"));
        UNIT_ASSERT_STRINGS_EQUAL("", signal.Process(""));

        for (int i = 0; i < 256; ++i) {
            UNIT_ASSERT_STRINGS_EQUAL("", signal.Process("2018-01-01 my_kokoko.ru 100500"));
        }
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",0]])", signal.SerializeForTest());

        signal.FlushBuffer();
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",256]])", signal.SerializeForTest());

        for (int i = 0; i < 256; ++i) {
            UNIT_ASSERT_STRINGS_EQUAL("", signal.Process("2018-01-01 her_kokoko. 100500"));
            UNIT_ASSERT_STRINGS_EQUAL("", signal.Process("k    ek"));
        }

        signal.FlushBuffer();
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",512]])", signal.SerializeForTest());

        signal.FlushBuffer();
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",512]])", signal.SerializeForTest());
    }
}
