#include <passport/infra/daemons/xunistater/ut/auto_uninstater.h>

#include <passport/infra/daemons/xunistater/src/signal_providers/sum.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NXunistater;

Y_UNIT_TEST_SUITE(Sum) {
    Y_UNIT_TEST(line) {
        TSignalSum signal("ololo", "dhhh");
        TAutoUnistater au(signal);

        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",0.0]])", signal.SerializeForTest());

        UNIT_ASSERT_STRINGS_EQUAL("sum: unexpected field format - is not double: 'kek'",
                                  signal.Process("kek"));

        for (int i = 0; i < 256; ++i) {
            UNIT_ASSERT_STRINGS_EQUAL("", signal.Process("100"));
        }
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",0.0]])", signal.SerializeForTest());

        signal.FlushBuffer();
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",25600.0]])", signal.SerializeForTest());

        for (int i = 0; i < 256; ++i) {
            UNIT_ASSERT_STRINGS_EQUAL("", signal.Process("0.5"));
            UNIT_ASSERT_STRINGS_EQUAL("", signal.Process("1"));
        }

        signal.FlushBuffer();
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",25984.0]])", signal.SerializeForTest());

        signal.FlushBuffer();
        UNIT_ASSERT_STRINGS_EQUAL(R"([["ololo_dhhh",25984.0]])", signal.SerializeForTest());
    }
}
