#include <passport/infra/daemons/xunistater/src/signal_template/field_getter.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NXunistater;
using namespace NPassport::NXunistater::NSt;

Y_UNIT_TEST_SUITE(StFieldGetter) {
    Y_UNIT_TEST(kv) {
        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TFieldGetter(TFieldGetter::TKvSettings{TFieldGetter::TKvSettings::EFrom::Key, "", false}),
            yexception,
            "FieldGetter: supports only Value. got: Key");
        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TFieldGetter(TFieldGetter::TKvSettings{TFieldGetter::TKvSettings::EFrom::Value, "", false}),
            yexception,
            "empty key is illegal");

        const NTskv::TKeyValue kv = {
            {"key1", "value1"},
            {"key2", ""},
        };

        UNIT_ASSERT_VALUES_EQUAL(
            TErrorableField({"", ""}),
            TFieldGetter(TFieldGetter::TKvSettings{TFieldGetter::TKvSettings::EFrom::Value, "key3", true}).Get(kv));
        UNIT_ASSERT_VALUES_EQUAL(
            TErrorableField({"", "key 'key3' is missing"}),
            TFieldGetter(TFieldGetter::TKvSettings{TFieldGetter::TKvSettings::EFrom::Value, "key3", false}).Get(kv));
        UNIT_ASSERT_VALUES_EQUAL(
            TErrorableField({"value1", ""}),
            TFieldGetter(TFieldGetter::TKvSettings{TFieldGetter::TKvSettings::EFrom::Value, "key1", false}).Get(kv));
        UNIT_ASSERT_VALUES_EQUAL(
            TErrorableField({"", ""}),
            TFieldGetter(TFieldGetter::TKvSettings{TFieldGetter::TKvSettings::EFrom::Value, "key2", false}).Get(kv));
    }

    Y_UNIT_TEST(arr) {
        const NTsv::TLine line = {"value1", ""};

        UNIT_ASSERT_VALUES_EQUAL(
            TErrorableField({"value1", ""}),
            TFieldGetter(TFieldGetter::TArraySettings{0}).Get(line));
        UNIT_ASSERT_VALUES_EQUAL(
            TErrorableField({"", ""}),
            TFieldGetter(TFieldGetter::TArraySettings{1}).Get(line));
        UNIT_ASSERT_VALUES_EQUAL(
            TErrorableField({"", "column==3 is missing"}),
            TFieldGetter(TFieldGetter::TArraySettings{2}).Get(line));
    }
}
