#include <passport/infra/daemons/xunistater/src/signal_template/name_builder.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NXunistater;
using namespace NPassport::NXunistater::NSt;

Y_UNIT_TEST_SUITE(StNameBuilder) {
    Y_UNIT_TEST(ctorExceptions) {
        const NTsv::TLine line = {"value1", "value2"};

        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TNameBuilder({}, {}),
            yexception,
            "do not use signal template without tokens: it is too expensive for trivial cases");

        std::vector<TTokenGetter> t;
        t.push_back(TTokenGetter::TArgs{
            {TFieldGetter::TArraySettings{1}},
            TTokenGetter::TFuncAsIs::Create(),
            "",
            {},
            {},
        });
        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TNameBuilder(std::move(t), {}),
            yexception,
            "token id cannot be empty");

        std::vector<TTokenGetter> t2;
        t2.push_back(TTokenGetter::TArgs{
            {TFieldGetter::TArraySettings{1}},
            TTokenGetter::TFuncAsIs::Create(),
            "some_id",
            {},
            {},
        });
        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TNameBuilder(std::move(t2), {}),
            yexception,
            "signal name cannot be empty");
    }

    Y_UNIT_TEST(BuildError) {
        const NTsv::TLine line = {"value1", "value2"};
        std::vector<TTokenGetter> t;

        t.push_back(TTokenGetter::TArgs{
            {TFieldGetter::TArraySettings{1}},
            TTokenGetter::TFuncAsIs::Create(),
            "some_id",
            {},
            {},
        });
        t.push_back(TTokenGetter::TArgs{
            {TFieldGetter::TArraySettings{10}},
            TTokenGetter::TFuncAsIs::Create(),
            "some_other_id",
            {},
            {},
        });
        TNameBuilder nb(std::move(t), "my mega pattern");

        UNIT_ASSERT_VALUES_EQUAL(TErrorableField({{}, "token='some_other_id' failed to get string: column==11 is missing"}),
                                 nb.Build(line));
    }

    Y_UNIT_TEST(BuildSuccess) {
        const NTsv::TLine line = {"value1", "value2"};
        std::vector<TTokenGetter> t;

        t.push_back(TTokenGetter::TArgs{
            {TFieldGetter::TArraySettings{1}},
            TTokenGetter::TFuncAsIs::Create(),
            "some_id",
            {},
            {},
        });
        t.push_back(TTokenGetter::TArgs{
            {TFieldGetter::TArraySettings{0}},
            TTokenGetter::TFuncAsIs::Create(),
            "some_other_id",
            {},
            {},
        });
        TNameBuilder nb2(std::move(t), "{$some_other_id} my  {$some_id} mega pattern");

        UNIT_ASSERT_VALUES_EQUAL(TErrorableField({"value1 my  value2 mega pattern", {}}),
                                 nb2.Build(line));

        const NTsv::TLine line2 = {"shaleyla", "eth0"};
        UNIT_ASSERT_VALUES_EQUAL(TErrorableField({"shaleyla my  eth0 mega pattern", {}}),
                                 nb2.Build(line2));
    }

    Y_UNIT_TEST(buildPersistentWithAllTokens) {
        std::vector<TTokenGetter> t;
        t.push_back(TTokenGetter::TArgs{
            .Getter = {TFieldGetter::TArraySettings{1}},
            .Func = TTokenGetter::TFuncAsIs::Create(),
            .Id = "some_id",
            .PersistentValues = {"A1", "A2", "A3", "A4"},
        });
        t.push_back(TTokenGetter::TArgs{
            .Getter = {TFieldGetter::TArraySettings{2}},
            .Func = TTokenGetter::TFuncAsIs::Create(),
            .Id = "some_other_id",
            .PersistentValues = {"B1"},
        });
        t.push_back(TTokenGetter::TArgs{
            .Getter = {TFieldGetter::TArraySettings{3}},
            .Func = TTokenGetter::TFuncAsIs::Create(),
            .Id = "some_another_id",
            .PersistentValues = {"C1", "C2", "C3"},
        });
        TNameBuilder nb(std::move(t), "{$some_id}_{$some_other_id}_{$some_another_id}");

        UNIT_ASSERT_VALUES_EQUAL(
            std::vector<TString>({
                "A1_B1_C1",
                "A1_B1_C2",
                "A1_B1_C3",
                "A2_B1_C1",
                "A2_B1_C2",
                "A2_B1_C3",
                "A3_B1_C1",
                "A3_B1_C2",
                "A3_B1_C3",
                "A4_B1_C1",
                "A4_B1_C2",
                "A4_B1_C3",
            }),
            nb.BuildPersistent());

        UNIT_ASSERT_VALUES_EQUAL(
            std::vector<TString>({
                "A1_B1_C1",
                "A1_B1_C2",
                "A1_B1_C3",
                "A1_B1_value3",
                "A1_value2_C1",
                "A1_value2_C2",
                "A1_value2_C3",
                "A1_value2_value3",
                "A2_B1_C1",
                "A2_B1_C2",
                "A2_B1_C3",
                "A2_B1_value3",
                "A2_value2_C1",
                "A2_value2_C2",
                "A2_value2_C3",
                "A2_value2_value3",
                "A3_B1_C1",
                "A3_B1_C2",
                "A3_B1_C3",
                "A3_B1_value3",
                "A3_value2_C1",
                "A3_value2_C2",
                "A3_value2_C3",
                "A3_value2_value3",
                "A4_B1_C1",
                "A4_B1_C2",
                "A4_B1_C3",
                "A4_B1_value3",
                "A4_value2_C1",
                "A4_value2_C2",
                "A4_value2_C3",
                "A4_value2_value3",
                "value1_B1_C1",
                "value1_B1_C2",
                "value1_B1_C3",
                "value1_B1_value3",
                "value1_value2_C1",
                "value1_value2_C2",
                "value1_value2_C3",
                "value1_value2_value3",
            }),
            nb.BuildWithPersistent(NTsv::TLine{"dummy", "value1", "value2", "value3"}));
    }

    Y_UNIT_TEST(buildPersistentWithPartTokens) {
        std::vector<TTokenGetter> t;
        t.push_back(TTokenGetter::TArgs{
            .Getter = {TFieldGetter::TArraySettings{1}},
            .Func = TTokenGetter::TFuncAsIs::Create(),
            .Id = "some_id",
            .PersistentValues = {},
        });
        t.push_back(TTokenGetter::TArgs{
            .Getter = {TFieldGetter::TArraySettings{2}},
            .Func = TTokenGetter::TFuncAsIs::Create(),
            .Id = "some_other_id",
            .PersistentValues = {},
        });
        t.push_back(TTokenGetter::TArgs{
            .Getter = {TFieldGetter::TArraySettings{3}},
            .Func = TTokenGetter::TFuncAsIs::Create(),
            .Id = "some_another_id",
            .PersistentValues = {"C1", "C2", "C3"},
        });
        TNameBuilder nb(std::move(t), "{$some_id}_{$some_other_id}_{$some_another_id}");

        UNIT_ASSERT_VALUES_EQUAL(std::vector<TString>({}), nb.BuildPersistent());

        UNIT_ASSERT_VALUES_EQUAL(
            std::vector<TString>({
                "value1_value2_C1",
                "value1_value2_C2",
                "value1_value2_C3",
                "value1_value2_value3",
            }),
            nb.BuildWithPersistent(NTsv::TLine{"dummy", "value1", "value2", "value3"}));

        UNIT_ASSERT_VALUES_EQUAL(
            std::vector<TString>({
                "value1_value2_C1",
                "value1_value2_C2",
                "value1_value2_C3",
                "value1_value2_C2",
            }),
            nb.BuildWithPersistent(NTsv::TLine{"dummy", "value1", "value2", "C2"}));
    }
}
