#include <passport/infra/daemons/xunistater/ut/auto_uninstater.h>

#include <passport/infra/daemons/xunistater/src/signal_template/signal_template.h>

#include <library/cpp/testing/unittest/registar.h>

#include <thread>

using namespace NPassport;
using namespace NPassport::NXunistater;
using namespace NPassport::NXunistater::NSt;

Y_UNIT_TEST_SUITE(StSignalTemplate) {
    TSignalTemplate CreateSignal() {
        std::vector<TTokenGetter> t;
        t.push_back(TTokenGetter::TArgs{
            {TFieldGetter::TKvSettings{TFieldGetter::TKvSettings::EFrom::Value, "key1", false}},
            TTokenGetter::TFuncAsIs::Create(),
            "some_id",
            {},
            {},
        });
        t.push_back(TTokenGetter::TArgs{
            {TFieldGetter::TKvSettings{TFieldGetter::TKvSettings::EFrom::Value, "key2", true}},
            TTokenGetter::TFuncAsIs::Create(),
            "some_other_id",
            {},
            {},
        });
        TNameBuilder nb(std::move(t), "{$some_other_id} my  {$some_id} mega pattern");
        TFieldGetter vg(TFieldGetter::TKvSettings{TFieldGetter::TKvSettings::EFrom::Value, "key3", false});
        TSignalFactoryPtr factory = std::make_unique<TRpsFactory>("_dmmm");

        return TSignalTemplate(std::move(nb), std::move(vg), std::move(factory));
    }

    Y_UNIT_TEST(ok) {
        TSignalTemplate cs = CreateSignal();
        TAutoUnistater au(cs);

        UNIT_ASSERT_VALUES_EQUAL("[]", SerializeForTest(cs));

        UNIT_ASSERT_VALUES_EQUAL("failed to get name for signal template: token='some_id' failed to get string: key 'key1' is missing",
                                 cs.Process(NTskv::TKeyValue{
                                     {"key2", ""},
                                 }));
        UNIT_ASSERT_VALUES_EQUAL("failed to get value for signal template: key 'key3' is missing",
                                 cs.Process(NTskv::TKeyValue{
                                     {"key1", "value1"},
                                     {"key2", ""},
                                 }));
        UNIT_ASSERT_VALUES_EQUAL("[]", SerializeForTest(cs));

        UNIT_ASSERT_VALUES_EQUAL("",
                                 cs.Process(NTskv::TKeyValue{
                                     {"key1", "value1"},
                                     {"key2", ""},
                                     {"key3", "value3"},
                                 }));
        UNIT_ASSERT_VALUES_EQUAL("[]", SerializeForTest(cs));
        UNIT_ASSERT_VALUES_EQUAL("",
                                 cs.Process(NTskv::TKeyValue{
                                     {"key1", "value1"},
                                     {"key2", "value2"},
                                     {"key3", "value3"},
                                 }));
        UNIT_ASSERT_VALUES_EQUAL("[]", SerializeForTest(cs));

        cs.FlushBuffer();
        UNIT_ASSERT_VALUES_EQUAL(R"([[" my  value1 mega pattern_dmmm",1],["value2 my  value1 mega pattern_dmmm",1]])",
                                 SerializeForTest(cs));
        cs.FlushBuffer();
        UNIT_ASSERT_VALUES_EQUAL(R"([[" my  value1 mega pattern_dmmm",1],["value2 my  value1 mega pattern_dmmm",1]])",
                                 SerializeForTest(cs));

        UNIT_ASSERT_VALUES_EQUAL("",
                                 cs.Process(NTskv::TKeyValue{
                                     {"key1", "value1"},
                                     {"key2", "value2"},
                                     {"key3", "value3"},
                                 }));
        UNIT_ASSERT_VALUES_EQUAL("",
                                 cs.Process(NTskv::TKeyValue{
                                     {"key1", "value11"},
                                     {"key2", "value21"},
                                     {"key3", "value3"},
                                 }));
        UNIT_ASSERT_VALUES_EQUAL(R"([[" my  value1 mega pattern_dmmm",1],["value2 my  value1 mega pattern_dmmm",1]])",
                                 SerializeForTest(cs));

        cs.FlushBuffer();
        UNIT_ASSERT_VALUES_EQUAL(R"([[" my  value1 mega pattern_dmmm",1],["value2 my  value1 mega pattern_dmmm",2],["value21 my  value11 mega pattern_dmmm",1]])",
                                 SerializeForTest(cs));
    }
}
