#include <passport/infra/daemons/xunistater/src/signal_template/token_getter.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NXunistater;
using namespace NPassport::NXunistater::NSt;

Y_UNIT_TEST_SUITE(StToken) {
    Y_UNIT_TEST(funcAsIs) {
        TTokenGetter::TFuncAsIs f;
        UNIT_ASSERT_VALUES_EQUAL(TErrorableField({"some mega value", {}}),
                                 f.Apply("some mega value"));
        UNIT_ASSERT_VALUES_EQUAL(TErrorableField({}),
                                 f.Apply(""));
    }

    Y_UNIT_TEST(funcRegex) {
        TTokenGetter::TFuncRegexGroup r(R"(http(s)?://([^/]+)/)", "some.$2.mega_$1 sig$2nal");

        UNIT_ASSERT_VALUES_EQUAL(TErrorableField({"some.yandex.ru.mega_s sigyandex.runal", {}}),
                                 r.Apply("https://yandex.ru/"));
        UNIT_ASSERT_VALUES_EQUAL(TErrorableField({"some.yandex.ru.mega_ sigyandex.runal", {}}),
                                 r.Apply("http://yandex.ru/"));
    }

    Y_UNIT_TEST(token) {
        const NTsv::TLine line = {"", "value2"};

        UNIT_ASSERT_VALUES_EQUAL(
            TErrorableField({"", "column==11 is missing"}),
            TTokenGetter(TTokenGetter::TArgs{
                             TFieldGetter(TFieldGetter::TArraySettings{10}),
                             TTokenGetter::TFuncAsIs::Create(),
                             "",
                             {},
                             {},
                         })
                .Get(line));
        UNIT_ASSERT_VALUES_EQUAL(
            TErrorableField({"", "func='regex_group' mismatched"}),
            TTokenGetter(TTokenGetter::TArgs{
                             TFieldGetter(TFieldGetter::TArraySettings{0}),
                             TTokenGetter::TFuncRegexGroup::Create(R"(value(\d))", "ogogo.$1"),
                             "",
                             {},
                             {},
                         })
                .Get(line));
        UNIT_ASSERT_VALUES_EQUAL(
            TErrorableField({"ogogo.2", ""}),
            TTokenGetter(TTokenGetter::TArgs{
                             TFieldGetter(TFieldGetter::TArraySettings{1}),
                             TTokenGetter::TFuncRegexGroup::Create(R"(value(\d))", "ogogo.$1"),
                             "",
                             {},
                             {},
                         })
                .Get(line));
    }

    Y_UNIT_TEST(missingok) {
        const NTskv::TKeyValue kv = {
            {"key1", "value1"},
            {"key2", ""},
        };

        // missingok == false
        UNIT_ASSERT_VALUES_EQUAL(
            TErrorableField({"value1", "", false}),
            TTokenGetter(TTokenGetter::TArgs{
                             TFieldGetter(TFieldGetter::TKvSettings{TFieldGetter::TKvSettings::EFrom::Value, "key1", false}),
                             TTokenGetter::TFuncAsIs::Create(),
                             "",
                             {},
                             {},
                         })
                .Get(kv));
        UNIT_ASSERT_VALUES_EQUAL(
            TErrorableField({"ogogo.1", "", false}),
            TTokenGetter(TTokenGetter::TArgs{
                             TFieldGetter(TFieldGetter::TKvSettings{TFieldGetter::TKvSettings::EFrom::Value, "key1", false}),
                             TTokenGetter::TFuncRegexGroup::Create(R"(value(\d))", "ogogo.$1"),
                             "",
                             {},
                             {},
                         })
                .Get(kv));

        UNIT_ASSERT_VALUES_EQUAL(
            TErrorableField({"", "", false}),
            TTokenGetter(TTokenGetter::TArgs{
                             TFieldGetter(TFieldGetter::TKvSettings{TFieldGetter::TKvSettings::EFrom::Value, "key2", false}),
                             TTokenGetter::TFuncAsIs::Create(),
                             "",
                             {},
                             {},
                         })
                .Get(kv));
        UNIT_ASSERT_VALUES_EQUAL(
            TErrorableField({"", "func='regex_group' mismatched", false}),
            TTokenGetter(TTokenGetter::TArgs{
                             TFieldGetter(TFieldGetter::TKvSettings{TFieldGetter::TKvSettings::EFrom::Value, "key2", false}),
                             TTokenGetter::TFuncRegexGroup::Create(R"(value(\d))", "ogogo.$1"),
                             "",
                             {},
                             {},
                         })
                .Get(kv));

        UNIT_ASSERT_VALUES_EQUAL(
            TErrorableField({"", "key 'key3' is missing", false}),
            TTokenGetter(TTokenGetter::TArgs{
                             TFieldGetter(TFieldGetter::TKvSettings{TFieldGetter::TKvSettings::EFrom::Value, "key3", false}),
                             TTokenGetter::TFuncAsIs::Create(),
                             "",
                             {},
                             {},
                         })
                .Get(kv));
        UNIT_ASSERT_VALUES_EQUAL(
            TErrorableField({"", "key 'key3' is missing", false}),
            TTokenGetter(TTokenGetter::TArgs{
                             TFieldGetter(TFieldGetter::TKvSettings{TFieldGetter::TKvSettings::EFrom::Value, "key3", false}),
                             TTokenGetter::TFuncRegexGroup::Create(R"(value(\d))", "ogogo.$1"),
                             "",
                             {},
                             {},
                         })
                .Get(kv));

        // missingok == true
        UNIT_ASSERT_VALUES_EQUAL(
            TErrorableField({"value1", "", true}),
            TTokenGetter(TTokenGetter::TArgs{
                             TFieldGetter(TFieldGetter::TKvSettings{TFieldGetter::TKvSettings::EFrom::Value, "key1", true}),
                             TTokenGetter::TFuncAsIs::Create(),
                             "",
                             {},
                             {},
                         })
                .Get(kv));
        UNIT_ASSERT_VALUES_EQUAL(
            TErrorableField({"ogogo.1", "", true}),
            TTokenGetter(TTokenGetter::TArgs{
                             TFieldGetter(TFieldGetter::TKvSettings{TFieldGetter::TKvSettings::EFrom::Value, "key1", true}),
                             TTokenGetter::TFuncRegexGroup::Create(R"(value(\d))", "ogogo.$1"),
                             "",
                             {},
                             {},
                         })
                .Get(kv));

        UNIT_ASSERT_VALUES_EQUAL(
            TErrorableField({"", "", true}),
            TTokenGetter(TTokenGetter::TArgs{
                             TFieldGetter(TFieldGetter::TKvSettings{TFieldGetter::TKvSettings::EFrom::Value, "key2", true}),
                             TTokenGetter::TFuncAsIs::Create(),
                             "",
                             {},
                             {},
                         })
                .Get(kv));
        UNIT_ASSERT_VALUES_EQUAL(
            TErrorableField({"", "", true}),
            TTokenGetter(TTokenGetter::TArgs{
                             TFieldGetter(TFieldGetter::TKvSettings{TFieldGetter::TKvSettings::EFrom::Value, "key2", true}),
                             TTokenGetter::TFuncRegexGroup::Create(R"(value(\d))", "ogogo.$1"),
                             "",
                             {},
                             {},
                         })
                .Get(kv));

        UNIT_ASSERT_VALUES_EQUAL(
            TErrorableField({"", "", true}),
            TTokenGetter(TTokenGetter::TArgs{
                             TFieldGetter(TFieldGetter::TKvSettings{TFieldGetter::TKvSettings::EFrom::Value, "key3", true}),
                             TTokenGetter::TFuncAsIs::Create(),
                             "",
                             {},
                             {},
                         })
                .Get(kv));
        UNIT_ASSERT_VALUES_EQUAL(
            TErrorableField({"", "", true}),
            TTokenGetter(TTokenGetter::TArgs{
                             TFieldGetter(TFieldGetter::TKvSettings{TFieldGetter::TKvSettings::EFrom::Value, "key3", true}),
                             TTokenGetter::TFuncRegexGroup::Create(R"(value(\d))", "ogogo.$1"),
                             "",
                             {},
                             {},
                         })
                .Get(kv));
    }

    Y_UNIT_TEST(withPostProcSingle) {
        UNIT_ASSERT_VALUES_EQUAL(
            TErrorableField({"value2", ""}),
            TTokenGetter(TTokenGetter::TArgs{
                             TFieldGetter(TFieldGetter::TArraySettings{1}),
                             TTokenGetter::TFuncAsIs::Create(),
                             "",
                             {},
                             {},
                         })
                .Get(NTsv::TLine{"", "value2"}));

        TTokenPostProcessors posts;

        posts.push_back(TTokenPostProcMap::Create(
            {
                {"value2", "val_out2"},
            },
            {}));
        UNIT_ASSERT_VALUES_EQUAL(
            TErrorableField({"val_out2", ""}),
            TTokenGetter(TTokenGetter::TArgs{
                             TFieldGetter(TFieldGetter::TArraySettings{1}),
                             TTokenGetter::TFuncAsIs::Create(),
                             "",
                             std::move(posts),
                             {},
                         })
                .Get(NTsv::TLine{"", "value2"}));
    }

    Y_UNIT_TEST(withPostProcMulti) {
        TTokenPostProcessors posts;

        posts.push_back(TTokenPostProcMap::Create(
            {
                {"value2", "val_mid"},
            },
            {}));
        posts.push_back(TTokenPostProcMap::Create(
            {
                {"val_mid", "val_out2"},
            },
            {}));
        posts.push_back(TTokenPostProcMap::Create(
            {
                {"value3", "val_out3"},
            },
            {}));
        UNIT_ASSERT_VALUES_EQUAL(
            TErrorableField({"val_out2", ""}),
            TTokenGetter(TTokenGetter::TArgs{
                             TFieldGetter(TFieldGetter::TArraySettings{1}),
                             TTokenGetter::TFuncAsIs::Create(),
                             "",
                             std::move(posts),
                             {},
                         })
                .Get(NTsv::TLine{"", "value2"}));
    }
}
