#include <passport/infra/daemons/xunistater/src/signal_template/token_postprocessor.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NXunistater::NSt;

Y_UNIT_TEST_SUITE(StTokenPostProc) {
    Y_UNIT_TEST(withDefault) {
        TTokenPostProcMap p(
            {
                {"in_1", "out_1"},
                {"in_2", "out_2"},
            },
            {"def_val"});

        UNIT_ASSERT_VALUES_EQUAL("out_1", p.Apply("in_1"));
        UNIT_ASSERT_VALUES_EQUAL("out_2", p.Apply("in_2"));
        UNIT_ASSERT_VALUES_EQUAL("def_val", p.Apply("in_3"));
    }

    Y_UNIT_TEST(withoutDefault) {
        TTokenPostProcMap p(
            {
                {"in_1", "out_1"},
                {"in_2", "out_2"},
            },
            {});

        UNIT_ASSERT_VALUES_EQUAL("out_1", p.Apply("in_1"));
        UNIT_ASSERT_VALUES_EQUAL("out_2", p.Apply("in_2"));
        UNIT_ASSERT_VALUES_EQUAL("in_3", p.Apply("in_3"));
    }
}
