#include <passport/infra/daemons/xunistater/src/storage/mem_storage.h>
#include <passport/infra/daemons/xunistater/src/storage/request_parser.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NXunistater;

Y_UNIT_TEST_SUITE(StorageParser) {
    class TMemStorageTest: public TMemStorage {
    public:
        using TMemStorage::TMemStorage;

        void AddValue(const TStringBuf key, double val, TInstant) override {
            Vals.push_back({TString(key), val});
        }

        using TVals = std::vector<std::pair<TString, double>>;
        TVals Vals;
    };

    Y_UNIT_TEST(errors) {
        TMemStorageTest s(TMemStorage::TSettings{});
        TString body;

        UNIT_ASSERT_EXCEPTION_CONTAINS(TRequestParser::Parse(s, "{"),
                                       yexception,
                                       "invalid json object: '{'");

        auto check = [&s](const TString& body) {
            UNIT_ASSERT_EXCEPTION_CONTAINS(TRequestParser::Parse(s, body),
                                           yexception,
                                           "required '/key1/value' as double: '" + body + "'");
        };

        check(R"({"key1":100})");
        check(R"({"key1":{"value":[]}})");
    }

    Y_UNIT_TEST(common) {
        auto check = [](const TMemStorageTest::TVals& vals, TStringBuf body) {
            TMemStorageTest s(TMemStorage::TSettings{});
            UNIT_ASSERT_NO_EXCEPTION(TRequestParser::Parse(s, body));
            UNIT_ASSERT_VALUES_EQUAL_C(vals, s.Vals, body);
        };

        check({
                  {"key1", 100},
              }, R"({"key1":{"value":100}})");

        check({
                  {"key1", 100},
                  {"key2", 118.5},
                  {"key3", 0.5},
              }, R"({"key1":{"value":100},"key2":{"value":118.5},"key3":{"value":0.5}})");
    }
}
