import os
import subprocess
import sys
import yatest.common as yc


XUNISTAT_CHECKER = yc.build_path() + '/passport/infra/daemons/xunistater/checker/xunistat_checker'
CONFIG_EXAMPLE = yc.source_path() + '/passport/infra/daemons/xunistater/config/tested_example.conf'

ENV = os.environ.copy()


def _canon_files(stdout):
    out = './tmp.out'
    with open(out, 'w') as f:
        f.write(stdout.decode('utf-8'))

    return [
        yc.canonical_file(out, local=True),
    ]


def test_checker_print():
    checker = subprocess.Popen(
        [
            XUNISTAT_CHECKER,
            'print_config',
            '-c',
            CONFIG_EXAMPLE,
        ],
        env=ENV,
        stdout=subprocess.PIPE,
        stderr=subprocess.PIPE,
    )
    stdout, stderr = checker.communicate()

    assert checker.wait() == 0

    stdout = stdout.replace(CONFIG_EXAMPLE.encode('utf-8'), '<<config_path>>'.encode('utf-8'))

    return _canon_files(stdout)


def test_checker_use_tsv_no_input():
    checker = subprocess.Popen(
        [
            XUNISTAT_CHECKER,
            'run_parser',
            'parser',
            '-c',
            CONFIG_EXAMPLE,
            '-p',
            "/config/component/parser[@id='parsemda']",
        ],
        env=ENV,
        stdin=subprocess.PIPE,
        stdout=subprocess.PIPE,
        stderr=sys.stderr,
    )
    stdout, stderr = checker.communicate(input=b'')

    assert b'' == stdout

    assert checker.wait() == 0


def test_checker_use_tsv_all():
    checker = subprocess.Popen(
        [
            XUNISTAT_CHECKER,
            'run_parser',
            'parser',
            '-c',
            CONFIG_EXAMPLE,
            '-p',
            "/config/component/parser[@id='parsemda']",
        ],
        env=ENV,
        stdin=subprocess.PIPE,
        stdout=subprocess.PIPE,
        stderr=sys.stderr,
    )

    stdin = b"""87.250.228.137 - pass.yandex.ru - [12/Sep/2019:01:08:54 +0300] pass.yandex.ru:80 0.010 0.000 75 "GET /ping HTTP/1.0" "502" 166 "-" "KeepAliveClient" "-" "-" "-" "-" "839bad1b1734006069a847311c9f58b8"
95.108.237.75 - pass.yandex.ru - [12/Sep/2019:01:08:55 +0300] pass.yandex.ru:80 0.001 0.000 75 "GET /nagios HTTP/1.0" "502" 166 "-" "KeepAliveClient" "-" "-" "-" "-" "12edf471016c743f28c58f3b0f6282db"
"""  # noqa
    stdout, stderr = checker.communicate(input=stdin)

    assert checker.wait() == 0

    return _canon_files(stdout)


def test_checker_use_tsv_several():
    checker = subprocess.Popen(
        [
            XUNISTAT_CHECKER,
            'run_parser',
            'parser',
            '-c',
            CONFIG_EXAMPLE,
            '-p',
            "/config/component/parser[@id='parsemda']",
            "/config/component/parser[@id='parsemda']/signals/signal[4]",
            "/config/component/parser[@id='parsemda']/signals/signal[5]",
            "/config/component/parser[@id='parsemda']/signals/signal_template[2]",
        ],
        env=ENV,
        stdin=subprocess.PIPE,
        stdout=subprocess.PIPE,
        stderr=sys.stderr,
    )

    stdin = b"""87.250.228.137 - pass.yandex.ru - [12/Sep/2019:01:08:54 +0300] pass.yandex.ru:80 0.010 0.000 75 "GET /ping HTTP/1.0" "502" 166 "-" "KeepAliveClient" "-" "-" "-" "-" "839bad1b1734006069a847311c9f58b8"
95.108.237.75 - pass.yandex.ru - [12/Sep/2019:01:08:55 +0300] pass.yandex.ua:80 0.001 0.000 75 "GET /nagios HTTP/1.0" "503" 166 "-" "KeepAliveClient" "-" "-" "-" "-" "12edf471016c743f28c58f3b0f6282db"
"""  # noqa
    stdout, stderr = checker.communicate(input=stdin)

    assert checker.wait() == 0

    return _canon_files(stdout)


def test_checker_use_tsv_regex():
    checker = subprocess.Popen(
        [
            XUNISTAT_CHECKER,
            'run_parser',
            'parser',
            '-c',
            CONFIG_EXAMPLE,
            '-p',
            "/config/component/parser[@id='parsenginx']",
        ],
        env=ENV,
        stdin=subprocess.PIPE,
        stdout=subprocess.PIPE,
        stderr=sys.stderr,
    )

    stdin = b"""2a0d:8180:1000:738b:994f:96c7:5e17:23d2 - api.passport.yandex.ru - [23/Sep/2019:02:00:59 +0300] api.passport.yandex.ru:443 0.000 0.000 1012 "POST /suggested_accounts/show_and_postpone HTTP/1.1" "200" 15 "https://yandex.ru/" "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36" "-" "yandexuid=3387137791569193241; i=6aEbdPe2BfqSMSUURpxsB3I9WoqimDgPvUWaP+q7egOArgASTx1Lppql3okTRy1LSIlWuOQWvSxcvVYCnP9mQv/lvpM=; mda=0; yandex_gid=213; my=YwA=; ys=wprid.1569193254965918-486557091088336884500103-vla1-2637; zm=m-white_bender.webp.css-https%3As3home-static_bMrlzJidv0686-YbTllrrhy5gPA%3Al; yabs-frequency=/4/0000000000000000/UrMmS80t87loFMs0DoS0/; yp=1571785251.ygu.1#1571785195.shlos.1#1600729196.p_sw.1569193195#1569797996.szm.1:1037x805:1037x805" "-" "72fc7bee857eddff3b7a8e5f66ea1f04"
lk;sfdnsdkjfnasdklfjnasklfjndsalkjnf
"""  # noqa
    stdout, stderr = checker.communicate(input=stdin)

    assert checker.wait() == 0

    return _canon_files(stdout)


def test_checker_use_tskv_all():
    checker = subprocess.Popen(
        [
            XUNISTAT_CHECKER,
            'run_parser',
            'tskv_parser',
            '-c',
            CONFIG_EXAMPLE,
            '-p',
            "/config/component/tskv_parser[@id='parseoauth']",
            '--condition_set',
            "/config/component/tskv_parser[@id='parseoauth']/condition_set[@id='alias']",
        ],
        env=ENV,
        stdin=subprocess.PIPE,
        stdout=subprocess.PIPE,
        stderr=sys.stderr,
    )

    stdin = b"""tskv	tskv_format=oauth-log	unixtime=1554884811	req_id=372eea59e0a40ed0	mode=verify_token	full_check=1	by_alias=1	status=error	token_id=274675	uid=4001166905	client_id=0c276fa84a544fd19d404db94e16970d	scopes=app_password:smtp,app_password:imap,app_password:pop3,app_password:xmpp	create_time=2015-08-07 17:05:56	issue_time=2015-08-07 17:05:56	user_ip=123.45.67.89	device_id=9ab543f031282c5c1484d090e2c25643	device_name=123	needs_refresh=0	reason=scopes.wrong	__consumer=1:passport_dev:2	__consumer_ip=2a02:6b8:c02:500:8000:611:0:1d
lk;sfdnsdkjfnasdklfjnasklfjndsalkjnf
tskv	tskv_format=oauth-log	unixtime=1554884811	req_id=6db2ab7c3e8658f0	mode=verify_token	full_check=1	by_alias=0	status=error	token_id=274675	uid=4001166905	client_id=0c276fa84a544fd19d404db94e16970d	scopes=app_password:smtp,app_password:imap,app_password:pop3,app_password:xmpp	create_time=2015-08-07 17:05:56	issue_time=2015-08-07 17:05:56	user_ip=123.45.67.89	device_id=9ab543f031282c5c1484d090e2c25643	device_name=123	needs_refresh=0	reason=user.revoked_app_password	__consumer=1:passport_dev:2	__consumer_ip=2a02:6b8:c02:500:8000:611:0:1d
tskv	tskv_format=oauth-log	unixtime=1554884811	req_id=6db2ab7c3e8658f0	mode=verify_token	full_check=1	by_alias=0	status=error	token_id=274675	uid=4001166905	client_id=0c276fa84a544fd19d404db94e16970d	scopes=app_password:smtp,app_password:imap,app_password:pop3,app_password:xmpp	create_time=2015-08-07 17:05:56	issue_time=2015-08-07 17:05:56	user_ip=123.45.67.89	device_id=9ab543f031282c5c1484d090e2c25643	device_name=123	needs_refresh=0	reason=user.revoked_app_password	__consumer=passport_dev	__consumer_ip=2a02:6b8:c02:500:8000:611:0:1d
"""  # noqa
    stdout, stderr = checker.communicate(input=stdin)

    assert checker.wait() == 0

    return _canon_files(stdout)


def test_checker_use_tskv_several():
    checker = subprocess.Popen(
        [
            XUNISTAT_CHECKER,
            'run_parser',
            'tskv_parser',
            '-c',
            CONFIG_EXAMPLE,
            '-p',
            "/config/component/tskv_parser[@id='parseoauth']",
            '--condition_set',
            "/config/component/tskv_parser[@id='parseoauth']/condition_set[@id='alias']",
            "/config/component/tskv_parser[@id='parseoauth']/condition_set[@id='alias']/signals/signal[3]",
            "/config/component/tskv_parser[@id='parseoauth']/condition_set[@id='alias']/signals/signal_template[1]",
        ],
        env=ENV,
        stdin=subprocess.PIPE,
        stdout=subprocess.PIPE,
        stderr=sys.stderr,
    )

    stdin = b"""tskv	tskv_format=oauth-log	unixtime=1554884811	req_id=372eea59e0a40ed0	mode=verify_token	full_check=1	by_alias=1	status=error	token_id=274675	uid=4001166905	client_id=0c276fa84a544fd19d404db94e16970d	scopes=app_password:smtp,app_password:imap,app_password:pop3,app_password:xmpp	create_time=2015-08-07 17:05:56	issue_time=2015-08-07 17:05:56	user_ip=123.45.67.89	device_id=9ab543f031282c5c1484d090e2c25643	device_name=123	needs_refresh=0	reason=scopes.wrong	__consumer=1:passport_dev:2	__consumer_ip=2a02:6b8:c02:500:8000:611:0:1d
tskv	tskv_format=oauth-log	unixtime=1554884811	req_id=6db2ab7c3e8658f0	mode=verify_token	full_check=1	by_alias=1	status=error	token_id=274675	uid=4001166905	client_id=0c276fa84a544fd19d404db94e16970d	scopes=app_password:smtp,app_password:imap,app_password:pop3,app_password:xmpp	create_time=2015-08-07 17:05:56	issue_time=2015-08-07 17:05:56	user_ip=123.45.67.89	device_id=9ab543f031282c5c1484d090e2c25643	device_name=123	needs_refresh=0	reason=user.revoked_app_password	__consumer=1:passport_dev:2	__consumer_ip=2a02:6b8:c02:500:8000:611:0:1d
"""  # noqa
    stdout, stderr = checker.communicate(input=stdin)

    assert checker.wait() == 0

    return _canon_files(stdout)


def test_checker_tskv_condition():
    checker = subprocess.Popen(
        [
            XUNISTAT_CHECKER,
            'tskv_condition',
            'config',
            '-c',
            CONFIG_EXAMPLE,
            '--condition_set',
            "/config/component/tskv_parser[@id='parseoauth']/condition_set[@id='alias']",
        ],
        env=ENV,
        stdin=subprocess.PIPE,
        stdout=subprocess.PIPE,
        stderr=sys.stderr,
    )

    stdin = b"""tskv	tskv_format=oauth-log	unixtime=1554884811	req_id=372eea59e0a40ed0	mode=verify_token	full_check=1	by_alias=1	status=error	token_id=274675	uid=4001166905	client_id=0c276fa84a544fd19d404db94e16970d	scopes=app_password:smtp,app_password:imap,app_password:pop3,app_password:xmpp	create_time=2015-08-07 17:05:56	issue_time=2015-08-07 17:05:56	user_ip=123.45.67.89	device_id=9ab543f031282c5c1484d090e2c25643	device_name=123	needs_refresh=0	reason=scopes.wrong	__consumer=1:passport_dev:2	__consumer_ip=2a02:6b8:c02:500:8000:611:0:1d
lk;sfdnsdkjfnasdklfjnasklfjndsalkjnf
tskv	tskv_format=oauth-log	unixtime=1554884811	req_id=6db2ab7c3e8658f0	mode=verify_token	full_check=1	by_alias=0	status=error	token_id=274675	uid=4001166905	client_id=0c276fa84a544fd19d404db94e16970d	scopes=app_password:smtp,app_password:imap,app_password:pop3,app_password:xmpp	create_time=2015-08-07 17:05:56	issue_time=2015-08-07 17:05:56	user_ip=123.45.67.89	device_id=9ab543f031282c5c1484d090e2c25643	device_name=123	needs_refresh=0	reason=user.revoked_app_password	__consumer=1:passport_dev:2	__consumer_ip=2a02:6b8:c02:500:8000:611:0:1d
"""  # noqa
    stdout, stderr = checker.communicate(input=stdin)

    assert checker.wait() == 0

    return _canon_files(stdout)


def test_checker_tskv_condition_arg():
    checker = subprocess.Popen(
        [
            XUNISTAT_CHECKER,
            'tskv_condition',
            'arg',
            '-c',
            'by_alias!=0 and mode==verify_token',
        ],
        env=ENV,
        stdin=subprocess.PIPE,
        stdout=subprocess.PIPE,
        stderr=sys.stderr,
    )

    stdin = b"""tskv	tskv_format=oauth-log	unixtime=1554884811	req_id=372eea59e0a40ed0	mode=verify_token	full_check=1	by_alias=1	status=error	token_id=274675	uid=4001166905	client_id=0c276fa84a544fd19d404db94e16970d	scopes=app_password:smtp,app_password:imap,app_password:pop3,app_password:xmpp	create_time=2015-08-07 17:05:56	issue_time=2015-08-07 17:05:56	user_ip=123.45.67.89	device_id=9ab543f031282c5c1484d090e2c25643	device_name=123	needs_refresh=0	reason=scopes.wrong	__consumer=1:passport_dev:2	__consumer_ip=2a02:6b8:c02:500:8000:611:0:1d
lk;sfdnsdkjfnasdklfjnasklfjndsalkjnf
tskv	tskv_format=oauth-log	unixtime=1554884811	req_id=6db2ab7c3e8658f0	mode=verify_token	full_check=1	by_alias=0	status=error	token_id=274675	uid=4001166905	client_id=0c276fa84a544fd19d404db94e16970d	scopes=app_password:smtp,app_password:imap,app_password:pop3,app_password:xmpp	create_time=2015-08-07 17:05:56	issue_time=2015-08-07 17:05:56	user_ip=123.45.67.89	device_id=9ab543f031282c5c1484d090e2c25643	device_name=123	needs_refresh=0	reason=user.revoked_app_password	__consumer=1:passport_dev:2	__consumer_ip=2a02:6b8:c02:500:8000:611:0:1d
"""  # noqa
    stdout, stderr = checker.communicate(input=stdin)

    assert checker.wait() == 0

    return _canon_files(stdout)


def test_checker_tsv_to_fields():
    checker = subprocess.Popen(
        [
            XUNISTAT_CHECKER,
            'tsv_to_fields',
            '-c',
            CONFIG_EXAMPLE,
            '-p',
            "/config/component/parser[@id='parsemda']",
        ],
        env=ENV,
        stdin=subprocess.PIPE,
        stdout=subprocess.PIPE,
        stderr=sys.stderr,
    )

    stdin = b"""87.250.228.137 - pass.yandex.ru - [12/Sep/2019:01:08:54 +0300] pass.yandex.ru:80 0.010 0.000 75 "GET /ping HTTP/1.0" "502" 166 "-" "KeepAliveClient" "-" "-" "-" "-" "839bad1b1734006069a847311c9f58b8"
95.108.237.75 - pass.yandex.ru - [12/Sep/2019:01:08:55 +0300] pass.yandex.ru:80 0.001 0.000 75 "GET /nagios HTTP/1.0" "502" 166 "-" "KeepAliveClient" "-" "-" "-" "-" "12edf471016c743f28c58f3b0f6282db"
"""  # noqa
    stdout, stderr = checker.communicate(input=stdin)

    assert checker.wait() == 0

    return _canon_files(stdout)


def test_checker_tsv_to_fields_regex():
    checker = subprocess.Popen(
        [
            XUNISTAT_CHECKER,
            'tsv_to_fields',
            '-c',
            CONFIG_EXAMPLE,
            '-p',
            "/config/component/parser[@id='parsenginx']",
        ],
        env=ENV,
        stdin=subprocess.PIPE,
        stdout=subprocess.PIPE,
        stderr=sys.stderr,
    )

    stdin = b"""2a0d:8180:1000:738b:994f:96c7:5e17:23d2 - api.passport.yandex.ru - [23/Sep/2019:02:00:59 +0300] api.passport.yandex.ru:443 0.000 0.000 1012 "POST /suggested_accounts/show_and_postpone HTTP/1.1" "200" 15 "https://yandex.ru/" "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.132 Safari/537.36" "-" "yandexuid=3387137791569193241; i=6aEbdPe2BfqSMSUURpxsB3I9WoqimDgPvUWaP+q7egOArgASTx1Lppql3okTRy1LSIlWuOQWvSxcvVYCnP9mQv/lvpM=; mda=0; yandex_gid=213; my=YwA=; ys=wprid.1569193254965918-486557091088336884500103-vla1-2637; zm=m-white_bender.webp.css-https%3As3home-static_bMrlzJidv0686-YbTllrrhy5gPA%3Al; yabs-frequency=/4/0000000000000000/UrMmS80t87loFMs0DoS0/; yp=1571785251.ygu.1#1571785195.shlos.1#1600729196.p_sw.1569193195#1569797996.szm.1:1037x805:1037x805" "-" "72fc7bee857eddff3b7a8e5f66ea1f04"
lk;sfdnsdkjfnasdklfjnasklfjndsalkjnf
"""  # noqa
    stdout, stderr = checker.communicate(input=stdin)

    assert checker.wait() == 0

    return _canon_files(stdout)


def test_checker_validate_bad():
    checker = subprocess.Popen(
        [
            XUNISTAT_CHECKER,
            'validate_config',
            '-c',
            yc.source_path() + '/passport/infra/daemons/xunistater/ut_py/invalid_config.xml',
        ],
        env=ENV,
        stdout=sys.stderr,
        stderr=subprocess.PIPE,
    )

    stdout, stderr = checker.communicate()

    assert (
        b"""Common WARNING: Soft schema validation failed for config: line=13. node=parser. errcode=504. message: Element parser content does not follow the DTD, expecting (http_path , period_to_check_file_ms? , lines_before_flush? , (delimeter_ascii_number? | regex) , ignore_parsing_errors? , ignore_processing_errors? , show_error_signal? , signals), got (http_path signal )
"""  # noqa
        in stderr
    )
    assert b"""Validation failed""" in stderr

    assert checker.wait() == 1


def test_checker_escape():
    checker = subprocess.Popen(
        [XUNISTAT_CHECKER, 'xml_escaping', 'a1!@#$%^&*()_+-=/~`<>,.?"\''],
        env=ENV,
        stdin=subprocess.PIPE,
        stdout=subprocess.PIPE,
        stderr=sys.stderr,
    )

    stdout, stderr = checker.communicate()

    assert (
        b"""a1!@#$%^&amp;*()_+-=/~`&lt;&gt;,.?&quot;&#39;
"""
        == stdout
    )

    assert checker.wait() == 0
