import json
import sys
import re

ENV_MAPPING = {
    "testing-beta": "development",
}

SETTINGS = {
    "development": {
        "SELF_TVM_ID": 2031390,
        "MYSQL_[RW]O_HOST": "localhost",
        "MYSQL_[RW]O_PORT": 3306,
        "MYSQL_[RW]O_USER": "/etc/yandex/passport-yasms-internal/mysql.user",
        "MYSQL_[RW]O_PASSWORD": "/etc/yandex/passport-yasms-internal/mysql.password",
        "IDM_SYSTEM": "yasms_adm_dev",
        "YT_CLUSTER": "hahn",
        "YT_DIR": "//home/passport-rt/development/yasms/config",
    },
    "testing": {
        "SELF_TVM_ID": 2031392,
        "MYSQL_[RW]O_HOST": "cnt-dbm-test.passport.yandex.net",
        "MYSQL_[RW]O_PORT": 3306,
        "MYSQL_[RW]O_USER": "/etc/yandex/passport-yasms-internal/mysql.user",
        "MYSQL_[RW]O_PASSWORD": "/etc/yandex/passport-yasms-internal/mysql.password",
        "IDM_SYSTEM": "yasms_adm_test",
        "YT_CLUSTER": "hahn",
        "YT_DIR": "//home/passport-rt/testing/yasms/config",
    },
    "production": {
        "SELF_TVM_ID": 2031394,
        "MYSQL_RO_HOST": "localhost",
        "MYSQL_RO_PORT": 3306,
        "MYSQL_RO_USER": "/etc/yandex/passport-yasms-internal/mysql.ro.user",
        "MYSQL_RO_PASSWORD": "/etc/yandex/passport-yasms-internal/mysql.ro.password",
        "MYSQL_WO_HOST": "yasms-s1.passport.yandex.net",
        "MYSQL_WO_PORT": 3306,
        "MYSQL_WO_USER": "/etc/yandex/passport-yasms-internal/mysql.rw.user",
        "MYSQL_WO_PASSWORD": "/etc/yandex/passport-yasms-internal/mysql.rw.password",
        "IDM_SYSTEM": "yasms_adm_prod",
        "YT_CLUSTER": "hahn",
        "YT_DIR": "//home/passport-rt/production/yasms/config",
    },
}


def do(template, env_type, env_name, hostname):
    env = '%s-%s' % (env_type, env_name) if env_name else env_type
    env = ENV_MAPPING.get(env, env)
    if env not in SETTINGS:
        raise Exception("env '%s' is unknown" % env)

    setts = SETTINGS[env]
    config = template
    for key, value in setts.items():
        config = re.sub('<<%s>>' % key, json.dumps(value), config)

    if '<<' in config or '>>' in config:
        raise Exception("some options were not specified: %s\n" % config)

    print(config)


if __name__ == '__main__':
    if len(sys.argv) != 5:
        print("Usage: {} <template_file> <env_type> <env_name> <hostname>".format(sys.argv[0]))
        sys.exit(1)

    with open(sys.argv[1]) as f:
        template = f.read()
        assert len(template) > 0

    do(template, sys.argv[2], sys.argv[3], sys.argv[4])
