package errs

import (
	"fmt"
)

type RequestStatus string

const (
	Ok    RequestStatus = "OK"
	Error RequestStatus = "ERROR"
)

type Component string

const (
	CommonComponent    Component = "common"
	ProcessorComponent Component = "processor"
	ProviderComponent  Component = "provider"
)

type RuntimeError struct {
	Message   string
	Component Component
}

func (error *RuntimeError) Error() string {
	return fmt.Sprintf("[%s] %s", error.Component, error.Message)
}

type UnauthorizedError struct {
	Status       RequestStatus `json:"status"`
	Message      string        `json:"message"`
	TicketStatus string        `json:"ticket_status,omitempty"`
	LoggablePart string        `json:"-"`

	Component Component `json:"-"`
}

func (error *UnauthorizedError) Error() string {
	return fmt.Sprintf("[%s] %s: %s, st: %s", error.Component, error.Status, error.Message, error.LoggablePart)
}

type AccessDeniedError struct {
	Status  RequestStatus `json:"status"`
	Message string        `json:"message"`

	Component Component `json:"-"`
}

func (error *AccessDeniedError) Error() string {
	return fmt.Sprintf("[%s] %s: %s", error.Component, error.Status, error.Message)
}

type BadRequestError struct {
	Status  RequestStatus `json:"status"`
	Message string        `json:"message"`

	Component Component `json:"-"`
}

func (error *BadRequestError) Error() string {
	return fmt.Sprintf("[%s] %s: %s", error.Component, error.Status, error.Message)
}

type UnknownError struct {
	Status  RequestStatus `json:"status"`
	Message string        `json:"message"`

	Component Component `json:"-"`
}

func (error *UnknownError) Error() string {
	return fmt.Sprintf("[%s] %s: %s", error.Component, error.Status, error.Message)
}
