package filter

type LogicOperator int

const (
	LogicAnd LogicOperator = iota
	LogicOr
)

var logicOpFromString = map[string]LogicOperator{
	"AND": LogicAnd,
	"OR":  LogicOr,
}

func (op LogicOperator) ToString() string {
	for str, curOp := range logicOpFromString {
		if op == curOp {
			return str
		}
	}
	return "unknown"
}

type CompareOperator int

const (
	Equal CompareOperator = iota
	NotEqual
	Contains
	StartsWith
	Less
	More
)

var compareOpFromString = map[string]CompareOperator{
	"EQUAL":       Equal,
	"NOT_EQUAL":   NotEqual,
	"CONTAINS":    Contains,
	"STARTS_WITH": StartsWith,
	"LESS":        Less,
	"MORE":        More,
}

func (op CompareOperator) ToString() string {
	for str, curOp := range compareOpFromString {
		if op == curOp {
			return str
		}
	}
	return "unknown"
}

func (op CompareOperator) ValuesArrayAllowed() bool {
	return op == Equal || op == NotEqual
}

type Filter interface {
	validateImpl(schema *Schema, meta validationMeta) error

	ToMySQLQuery(fields map[string]string, args []interface{}) (string, []interface{}, error)
}

type FilterContainer struct {
	Filter
}

type LogicOpFilter struct {
	LogicOp LogicOperator
	Args    []FilterContainer
}

type FieldFilter struct {
	Field     string
	CompareOp CompareOperator
	Values    []string
}
