/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

/*!40000 DROP DATABASE IF EXISTS `sms`*/;

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `sms` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `sms`;
DROP TABLE IF EXISTS `blockedphones`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `blockedphones` (
  `blockid` bigint NOT NULL AUTO_INCREMENT,
  `phone` varchar(40) NOT NULL DEFAULT '',
  `phoneid` bigint NOT NULL DEFAULT '0',
  `blocktype` enum('permanent','temporary') NOT NULL DEFAULT 'temporary',
  `blocktill` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY (`blockid`,`phone`,`phoneid`,`blocktype`,`blocktill`)
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `blockedphones` WRITE;
/*!40000 ALTER TABLE `blockedphones` DISABLE KEYS */;
INSERT INTO `blockedphones` VALUES (54,'+79037177191',0,'permanent','2021-12-29 16:09:48'),(55,'+79095856762',0,'permanent','2070-12-29 16:19:31');
/*!40000 ALTER TABLE `blockedphones` ENABLE KEYS */;
UNLOCK TABLES;

DROP TABLE IF EXISTS `fallbacks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `fallbacks` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `srcgate` varchar(20) NOT NULL,
  `srcname` varchar(20) NOT NULL,
  `dstgate` varchar(20) NOT NULL,
  `dstname` varchar(20) NOT NULL,
  `order` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `fallbacks` WRITE;
/*!40000 ALTER TABLE `fallbacks` DISABLE KEYS */;
ALTER TABLE `fallbacks` ADD UNIQUE KEY `fallback` (`srcgate`,`srcname`,`dstgate`,`dstname`);
/*!40000 ALTER TABLE `fallbacks` ENABLE KEYS */;
INSERT INTO `fallbacks` VALUES (33,'infobip','Yandex','gms','Yandex',0),(42,'gms','Yandex','m1','Yandex',1);
UNLOCK TABLES;

DROP TABLE IF EXISTS `smsgates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `smsgates` (
  `gateid` bigint NOT NULL AUTO_INCREMENT,
  `aliase` varchar(20) NOT NULL DEFAULT '',
  `fromname` varchar(20) NOT NULL DEFAULT 'Yandex',
  `description` varchar(60) DEFAULT NULL,
  `delay` int NOT NULL DEFAULT '100',
  PRIMARY KEY (`gateid`),
  UNIQUE KEY `aliase` (`aliase`,`fromname`),
  KEY `gateseek` (`gateid`,`aliase`)
) ENGINE=InnoDB AUTO_INCREMENT=116 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `smsgates` WRITE;
/*!40000 ALTER TABLE `smsgates` DISABLE KEYS */;
INSERT INTO `smsgates` VALUES (113,'mitto','Yandex','contractor=mitto;consumer=yandex',0),(114,'m1','Yandex','contractor=m1service;consumer=yandex',100),(115,'infobipvrt','o.yandex.ru','contractor=infobip;consumer=vertis',100);
/*!40000 ALTER TABLE `smsgates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `smsrt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `smsrt` (
  `ruleid` bigint NOT NULL AUTO_INCREMENT,
  `destination` varchar(40) NOT NULL DEFAULT '',
  `gateid` bigint NOT NULL DEFAULT '0',
  `gateid2` bigint NOT NULL DEFAULT '0',
  `gateid3` bigint NOT NULL DEFAULT '0',
  `mode` varchar(16) NOT NULL DEFAULT 'default',
  `weight` tinyint unsigned DEFAULT '1',
  `groupname` varchar(40) NOT NULL DEFAULT '',
  PRIMARY KEY (`ruleid`,`destination`),
  UNIQUE KEY `destination` (`destination`,`gateid`,`mode`),
  KEY `gateid` (`gateid`),
  KEY `bymode` (`mode`,`destination`)
) ENGINE=InnoDB AUTO_INCREMENT=4487 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `smsrt` WRITE;
/*!40000 ALTER TABLE `smsrt` DISABLE KEYS */;
INSERT INTO `smsrt` VALUES (4484,'+7123',113,114,115,'default',1,''),(4485,'+225',115,114,0,'validate',1,''),(4486,'+99833',114,0,0,'validate',2,'');
/*!40000 ALTER TABLE `smsrt` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

DROP TABLE IF EXISTS `regions`;
CREATE TABLE `regions` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `prefix` varchar(20) NOT NULL,
    `name` varchar(40) NOT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `regions` WRITE;
/*!40000 ALTER TABLE `regions` DISABLE KEYS */;
ALTER TABLE `regions` ADD UNIQUE KEY `region` (`prefix`,`name`);
/*!40000 ALTER TABLE `regions` ENABLE KEYS */;
INSERT INTO `regions` VALUES  (1,'+','Other'), (2,'+7','Russia'),(3,'+735190','Chelyabinsk region'), (4, '+225', 'Côte d''Ivoire'), (5, '+99833', 'Uzbekistan');
UNLOCK TABLES;

DROP TABLE IF EXISTS `preserved_regions`;
CREATE TABLE preserved_regions (
    region_id bigint(20) PRIMARY KEY,
    FOREIGN KEY (region_id) REFERENCES regions (id)
);

INSERT INTO preserved_regions (region_id) VALUES (1);

/*PASSP-38163*/

DROP TABLE IF EXISTS `audit_bulk`;
CREATE TABLE audit_bulk (
    `bulk_id` bigint(20) PRIMARY KEY NOT NULL AUTO_INCREMENT,
    `timestamp` int(11) unsigned,
    `author` varchar(40) NOT NULL,
    `issue` varchar(128) NOT NULL,
    `comment` varchar(128) NOT NULL
);

DROP TABLE IF EXISTS `audit_row`;
CREATE TABLE audit_row (
    `row_id` bigint(20) PRIMARY KEY NOT NULL AUTO_INCREMENT,
    `bulk_id` bigint(20) NOT NULL,
    `table_name` varchar(40) NOT NULL,
    `type` varchar(40) NOT NULL,
    `entity_id` bigint(20) NOT NULL,
    `payload` TEXT,
    FOREIGN KEY (bulk_id) REFERENCES audit_bulk (bulk_id)
);

LOCK TABLES `blockedphones` WRITE;
ALTER TABLE `blockedphones`
    ADD COLUMN `event_create` bigint(20),
    ADD COLUMN `event_modify` bigint(20),
    ADD FOREIGN KEY (`event_create`) REFERENCES `audit_row` (`row_id`),
    ADD FOREIGN KEY (`event_modify`) REFERENCES `audit_row` (`row_id`)
;
UNLOCK TABLES;

LOCK TABLES `fallbacks` WRITE;
ALTER TABLE `fallbacks`
    ADD COLUMN `event_create` bigint(20),
    ADD COLUMN `event_modify` bigint(20),
    ADD FOREIGN KEY (`event_create`) REFERENCES `audit_row` (`row_id`),
    ADD FOREIGN KEY (`event_modify`) REFERENCES `audit_row` (`row_id`)
;
UNLOCK TABLES;

LOCK TABLES `smsgates` WRITE;
ALTER TABLE `smsgates`
    ADD COLUMN `event_create` bigint(20),
    ADD COLUMN `event_modify` bigint(20),
    ADD FOREIGN KEY (`event_create`) REFERENCES `audit_row` (`row_id`),
    ADD FOREIGN KEY (`event_modify`) REFERENCES `audit_row` (`row_id`)
;
UNLOCK TABLES;

LOCK TABLES `smsrt` WRITE;
ALTER TABLE `smsrt`
    ADD COLUMN `event_create` bigint(20) NULL,
    ADD COLUMN `event_modify` bigint(20) NULL,
    ADD FOREIGN KEY (`event_create`) REFERENCES `audit_row` (`row_id`),
    ADD FOREIGN KEY (`event_modify`) REFERENCES `audit_row` (`row_id`)
;
UNLOCK TABLES;

LOCK TABLES `regions` WRITE;
ALTER TABLE `regions`
    ADD COLUMN `event_create` bigint(20),
    ADD COLUMN `event_modify` bigint(20),
    ADD FOREIGN KEY (`event_create`) REFERENCES `audit_row` (`row_id`),
    ADD FOREIGN KEY (`event_modify`) REFERENCES `audit_row` (`row_id`)
;
UNLOCK TABLES;

DROP TABLE IF EXISTS `templates`;
CREATE TABLE `templates` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT,
    `text` text NOT NULL,
    `abc_service` varchar(20) NOT NULL,
    `sender_meta` json,
    `fields_description` json,
    `event_create` bigint(20),
    `event_modify` bigint(20),
    PRIMARY KEY (`id`),
    FOREIGN KEY (`event_create`) REFERENCES `audit_row` (`row_id`),
    FOREIGN KEY (`event_modify`) REFERENCES `audit_row` (`row_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

LOCK TABLES `templates` WRITE;
INSERT INTO `templates` VALUES (4, 'I see a {{name}} and code {{code}}', 'passport_infra', '{"whatsapp": {"id": 1111}}', '{"code": {"privacy": "secret"}}', null, null),
    (8, 'New {{service}} init', 'passport_infra', '{"whatsapp": {"id": 2222}}', null, null, null);
UNLOCK TABLES;

