package model

import (
	"context"

	"a.yandex-team.ru/passport/infra/daemons/yasms_internal/internal/filter"
	"a.yandex-team.ru/passport/shared/golibs/juggler"
)

type Provider interface {
	Reader
	Writer
}

type YtTablesProvider interface {
	YtTablesWriter
}

type YtTablesWriter interface {
	SaveRegions(context context.Context, regions []*Region) error
	SaveGates(context context.Context, gates []*GateWithAudit) error
	GetJugglerStatus() *juggler.Status
}

type Reader interface {
	GetRouteEnums(ctx context.Context) (*Enums, error)
	GetRoutesInfo(ctx context.Context, fromID EntityID, limit uint64, routesFilter filter.Filter) ([]*RouteInfo, error)
	GetRoutesCount(ctx context.Context, routesFilter filter.Filter) (uint64, error)

	GetGates(ctx context.Context, fromID EntityID, limit uint64, gatesFilter filter.Filter) ([]*GateWithAudit, error)
	GetGatesCount(ctx context.Context, gatesFilter filter.Filter) (uint64, error)
	GetAllGates(ctx context.Context) ([]*GateWithAudit, error)

	GetBlockedPhones(ctx context.Context, fromID EntityID, limit uint64, blockedPhonesFilter filter.Filter) ([]*BlockedPhone, error)
	GetBlockedPhonesCount(ctx context.Context, blockedPhonesFilter filter.Filter) (uint64, error)

	GetFallbacks(ctx context.Context, fromID EntityID, limit uint64, fallbacksFilter filter.Filter) ([]*Fallback, error)
	GetFallbacksCount(ctx context.Context, fallbacksFilter filter.Filter) (uint64, error)

	GetRegions(ctx context.Context, regionsFilter filter.Filter) ([]*Region, error)

	GetTemplates(ctx context.Context, fromID EntityID, limit uint64, templatesFilter filter.Filter) ([]*Template, error)
	GetTemplatesCount(ctx context.Context, templatesFilter filter.Filter) (uint64, error)

	GetAuditBulkInfo(ctx context.Context, id EntityID) (*AuditBulkInfo, error)
	GetAuditChangeInfo(ctx context.Context, changeIds []EntityID) (*AuditChangesInfo, error)

	GetName() string
	GetJugglerStatus() *juggler.Status
}

type Writer interface {
	SetRoutes(ctx context.Context, delete []EntityID, create []*Route, update []*Route, auditLogBulkParams *AuditLogBulkParams) error
	SetGates(ctx context.Context, delete []EntityID, create []*Gate, update []*Gate, auditLogBulkParams *AuditLogBulkParams) error
	SetBlockedPhones(ctx context.Context, delete []EntityID, create []*BlockedPhone, update []*BlockedPhone, auditLogBulkParams *AuditLogBulkParams) error
	SetFallbacks(ctx context.Context, delete []EntityID, create []*Fallback, update []*Fallback, auditLogBulkParams *AuditLogBulkParams) error
	SetRegions(ctx context.Context, delete []EntityID, create []*Region, update []*Region, auditLogBulkParams *AuditLogBulkParams) error
	SetTemplates(ctx context.Context, create []*Template, update []*Template, auditLogBulkParams *AuditLogBulkParams) error
	GetName() string
	GetJugglerStatus() *juggler.Status
}
