package ytc

import (
	"context"

	"a.yandex-team.ru/passport/infra/daemons/yasms_internal/internal/model"
)

type regionRowKeys struct {
	Prefix string `yson:"prefix"`
}

type regionRow struct {
	regionRowKeys
	rowTypeInterface
	Name string `yson:"name"`
}

type gateRowKeys struct {
	GateID string `yson:"gateid"`
}

type gateRow struct {
	gateRowKeys
	rowTypeInterface
	Alias      string `yson:"aliase"`
	AlphaName  string `yson:"fromname"`
	Consumer   string `yson:"consumer"`
	Contractor string `yson:"contractor"`
}

func (row regionRow) getKey() rowKeysInterface {
	return &regionRowKeys{
		Prefix: row.Prefix,
	}
}

func (row gateRow) getKey() rowKeysInterface {
	return &gateRowKeys{
		GateID: row.GateID,
	}
}

const (
	regionsTable = "regions/regions"
	gatesTable   = "gates/gates"

	getAllRegionsQuery = "name, prefix FROM [%s]"
	getAllGatesQuery   = "gateid, aliase, fromname, consumer, contractor FROM [%s]"
)

func (provider *Provider) SaveRegions(ctx context.Context, regions []*model.Region) error {
	return SaveTableToYt[regionRow, regionRowKeys](ctx, prepareRegionsRows(regions), getAllRegionsQuery, regionsTable, provider)
}

func (provider *Provider) SaveGates(ctx context.Context, gates []*model.GateWithAudit) error {
	return SaveTableToYt[gateRow, gateRowKeys](ctx, prepareGatesRows(gates), getAllGatesQuery, gatesTable, provider)
}

func prepareRegionsRows(regions []*model.Region) []interface{} {
	res := make([]interface{}, 0, len(regions))
	for _, region := range regions {
		res = append(res, regionRow{
			regionRowKeys: regionRowKeys{
				Prefix: region.Prefix,
			},
			Name: region.Name,
		})
	}
	return res
}

func prepareGatesRows(gates []*model.GateWithAudit) []interface{} {
	res := make([]interface{}, 0, len(gates))
	for _, gate := range gates {
		res = append(res, gateRow{
			gateRowKeys: gateRowKeys{
				GateID: gate.ID,
			},
			Alias:      gate.Alias,
			AlphaName:  gate.AlphaName,
			Consumer:   gate.Consumer,
			Contractor: gate.Contractor,
		})
	}
	return res
}
