package processor

import (
	"context"

	"a.yandex-team.ru/passport/infra/daemons/yasms_internal/internal/errs"
	"a.yandex-team.ru/passport/infra/daemons/yasms_internal/internal/model"
	"a.yandex-team.ru/passport/shared/golibs/logger"
)

type (
	GetAuditBulkInfoRequest struct {
		BulkID model.EntityID `query:"bulk_id"`
	}

	GetAuditBulkInfoResponse struct {
		AuditBulkInfo model.AuditBulkInfo `json:"audit_bulk_info"`
	}

	GetAuditChangeInfoRequest struct {
		ChangeIDs []model.EntityID `query:"change_id" query_multi:"true"`
	}

	GetAuditChangeInfoResponse struct {
		AuditChangesInfo model.AuditChangesInfo `json:"audit_changes_info"`
	}
)

func (processor *Processor) HandleAuditBulkInfo(
	ctx context.Context,
	request GetAuditBulkInfoRequest,
) (*GetAuditBulkInfoResponse, error) {

	response := &GetAuditBulkInfoResponse{}
	info, err := processor.fetcher.GetAuditBulkInfo(ctx, request.BulkID)

	if err != nil {
		logger.Log().Errorf("failed to fetch audit bulk info: %s", err)
		return nil, &errs.UnknownError{
			Status:  errs.Error,
			Message: "failed to fetch audit bulk info",

			Component: errs.ProcessorComponent,
		}
	}

	if info != nil {
		response.AuditBulkInfo = *info
	}

	return response, nil
}

func (processor *Processor) HandleAuditChangeInfo(
	ctx context.Context,
	request GetAuditChangeInfoRequest,
) (*GetAuditChangeInfoResponse, error) {
	response := &GetAuditChangeInfoResponse{}
	info, err := processor.fetcher.GetAuditChangeInfo(ctx, request.ChangeIDs)

	if err != nil {
		logger.Log().Errorf("failed to fetch audit change info: %s", err)
		return nil, &errs.UnknownError{
			Status:  errs.Error,
			Message: "failed to fetch audit change info",

			Component: errs.ProcessorComponent,
		}
	}

	if info != nil {
		response.AuditChangesInfo = *info
	}

	return response, nil
}
