package processor

import (
	"context"

	"a.yandex-team.ru/passport/infra/daemons/yasms_internal/internal/errs"
	"a.yandex-team.ru/passport/infra/daemons/yasms_internal/internal/model"
	"a.yandex-team.ru/passport/shared/golibs/logger"
)

type EnumsResponse = model.Enums

func (processor *Processor) HandleRouteEnums(ctx context.Context) (*EnumsResponse, error) {
	response, err := processor.fetcher.GetRouteEnums(ctx)
	if err != nil {
		logger.Log().Warnf("failed fetch enums: %s", err.Error())
		return nil, &errs.UnknownError{
			Status:  errs.Error,
			Message: "failed to fetch enums",

			Component: errs.ProcessorComponent,
		}
	}

	return response, nil
}
