package processor

import (
	"fmt"
	"net/url"

	"a.yandex-team.ru/passport/infra/daemons/yasms_internal/internal/errs"
	"a.yandex-team.ru/passport/infra/daemons/yasms_internal/internal/filter"
	"a.yandex-team.ru/passport/infra/daemons/yasms_internal/internal/model"
)

func makeNextURL(path string, id model.EntityID, limit uint64) string {
	return fmt.Sprintf("%s?min=%s&limit=%d", path, url.QueryEscape(id), limit)
}

func makeNextURLWithFilter(path string, id model.EntityID, limit uint64, filter string) string {
	nextURL := makeNextURL(path, id, limit)
	if filter != "" {
		return fmt.Sprintf("%s&filter=%s", nextURL, url.QueryEscape(filter))
	}
	return nextURL
}

func max(a, b uint64) uint64 {
	if a > b {
		return a
	}
	return b
}

func GetSelectFilter(requestFilter string, schema *filter.Schema) (filter.Filter, error) {
	var fieldsFilter filter.Filter
	if requestFilter != "" {
		var err error
		fieldsFilter, err = filter.FromJSON([]byte(requestFilter))
		if err != nil {
			return nil, &errs.BadRequestError{
				Status:  errs.Error,
				Message: fmt.Sprintf("invalid filter: %s", err.Error()),

				Component: errs.ProcessorComponent,
			}
		}
		err = schema.Validate(fieldsFilter)
		if err != nil {
			return nil, &errs.BadRequestError{
				Status:  errs.Error,
				Message: fmt.Sprintf("invalid filter: %s", err.Error()),

				Component: errs.ProcessorComponent,
			}
		}
		return fieldsFilter, nil
	}
	return nil, nil
}

func GetRoutesRegion(phonePrefix string, allRegions []*model.Region) (*model.Region, error) {
	regions := make(model.Regions)
	for _, region := range allRegions {
		regions[region.Prefix] = &model.Region{
			Name: region.Name,
		}
	}
	region, err := regions.GetRegion(phonePrefix)
	if err != nil {
		return nil, fmt.Errorf("failed to select regions: %s", err)
	}
	return region, nil
}
