package main

import (
	"fmt"
	"net/http"
	"os"
	"strconv"
)

func SimpleHandler(response string) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		w.WriteHeader(http.StatusOK)
		_, err := w.Write([]byte(response))
		if err != nil {
			fmt.Printf("Failed to write response: %s", err)
		}
	}
}

func RunServer(port uint16) {
	fmt.Printf("Starting \"blackbox\" server at port %d\n", port)

	http.HandleFunc("/blackbox", SimpleHandler(`{
"users" : [
	{
		"id" : "400001328821",
		"karma" : {
			"value" : 0
		},
		"karma_status" : {
			"value" : 0
		},
		"uid" : {}
	},
	{
		"address-list" : [
		{
			"address" : "test@yandex.ru",
			"born-date" : "2011-11-16 00:00:00",
			"default" : true,
			"native" : true,
			"rpop" : false,
			"unsafe" : false,
			"validated" : true
		}
		],
		"aliases" : {
			"6" : "uid-sjywgxrn"
		},
		"attributes" : {
			"1" : "1294999198",
			"25" : "1:Девичья фамилия матери"
		},
		"dbfields" : {
			"accounts.login.uid" : "test",
			"userinfo.firstname.uid" : null
		},
		"display_name" : {
			"avatar" : {
				"default" : "4000217463",
				"empty" : false
			},
			"name" : "Козьма Прутков",
			"public_name" : "Козьма П.",
			"social" : {
			"profile_id" : "5328",
			"provider" : "tw",
			"redirect_target" : "1323266014.26924.5328.9e5e3b502d5ee16abc40cf1d972a1c17"
		}
	},
	"emails" : [
		{
			"attributes" : {
				"1" : "my_email@gmail.com"
			},
			"id" : "2"
		}
	],
	"id" : "3000062912",
	"karma" : {
		"allow-until" : 1321965947,
		"value" : 85
	},
	"karma_status" : {
		"value" : 3085
	},
	"login" : "test_login",
	"phones" : [
		{
			"attributes" : {
				"6" : "1412183145"
			},
			"id" : "2"
		}
	],
	"pin_status" : true,
	"public_id" : "mcat26m4cb7z951vv46zcbzgqt",
	"regname" : "test",
	"uid" : {
		"catch_all" : "",
		"domain" : "",
		"domain_ena" : "",
		"domid" : "",
		"hosted" : false,
		"mx" : "",
		"value" : "3000062912"
	}
	}
]
}`))

	err := http.ListenAndServe(fmt.Sprintf(":%d", port), nil)
	if err != http.ErrServerClosed {
		fmt.Println(err)
	}
}

func main() {
	port, err := strconv.ParseUint(os.Args[1], 10, 16)
	if err != nil {
		fmt.Printf("Invalid argument <port>: must be uint, got %s\n", os.Args[1])
		return
	}

	RunServer(uint16(port))
}
