import json
import os
import subprocess
import MySQLdb

import yatest.common as yc
from yatest.common import network

from passport.infra.daemons.yasms_internal.ut.schemas import delete_table, REGIONS_TABLE_NAME
from passport.infra.recipes.common import log, start_daemon, stop_daemon

# Src: 1000502 Dst: 1000501
SERVICE_TICKET = '3:serv:CBAQ__________9_IggItog9ELWIPQ:RJzEMLq9q-KUkOAUMVLlKSj-LlikhYkwUMBgookxl-oX-PBmDdFy9u8dpmzJUg2GiwmHnPVRmyK9T1id98qFsLHMfYvcGfmUS1bqaLYdzDH4O3yjVHEQsJdTmPDI2F_529U92i0t9sSKigASODfkMO2cMK4gALO1ky4X4Er2fOs'  # noqa
# from 1120000000000001 user
USER_TICKET = '3:user:CAwQ__________9_GhwKCQiBgJiRpdT-ARCBgJiRpdT-ASDShdjMBCgC:SFId7yy3kHBoQ5VfilzhAoHRlPuMqPz1kyJ2ynELC6jIfTf2qASuQXEdlwjZv49-aXsi1M38p0k7etKKnLSfncUYekEp1Hu3ggXHFgk55BSpxXBAd5NORSN8G3zuQkahCfgUjCsvIZ2DyFM-fF2zMdKZL4qnPDDruXwnI6Rk-lA'  # noqa
AUTH_HEADERS = {"X-Ya-Service-Ticket": SERVICE_TICKET, "X-Ya-User-Ticket": USER_TICKET}


class YaSMSInternalFixture:
    def __init__(self):
        self._pm = network.PortManager()

        config_path = yc.output_path('yasms-internal.conf')
        tvm_cache_dir = yc.output_path('tvm_cache')
        tvm_secret_path = yc.output_path('tvm.secret')

        self.cache_dir = yc.output_path('cache')

        mysql_user_path = yc.output_path('mysql.user')
        mysql_password_path = yc.output_path('mysql.password')

        with open(mysql_user_path, 'w') as f:
            f.write("root")

        with open(mysql_password_path, 'w') as f:
            f.write("")

        if not os.path.isdir(self.cache_dir):
            os.mkdir(self.cache_dir)

        if not os.path.isdir(tvm_cache_dir):
            os.mkdir(tvm_cache_dir)

        self.http_port = self._pm.get_tcp_port()
        self.unistat_port = self._pm.get_tcp_port()
        self.blackbox_port = self._pm.get_tcp_port()

        self.url = 'http://127.0.0.1:{port}'.format(port=self.http_port)

        def read_port(filename):
            try:
                with open(filename) as f:
                    return int(f.read())
            except IOError:
                log('Could not find port file: %s' % filename)
                exit(1)

        tvmapi_port = read_port('./tvmapi.port')
        tirole_port = read_port('./tirole.port')
        self.mysql_port = read_port('./mysql.port')

        with open(tvm_secret_path, 'w') as f:
            f.write("bAicxJVa5uVY7MjDlapthw")

        command = [
            yc.build_path('passport/infra/daemons/yasms_internal/ut/blackbox_mock/blackbox_server'),
            str(self.blackbox_port),
        ]
        self._blackbox_process = start_daemon(command, os.environ.copy(), self.blackbox_port)

        blackbox_address = 'http://localhost:{}'.format(self.blackbox_port)

        yasms_internal_config = {
            "http_common": {"listen_address": "localhost", "port": self.http_port, "cert": "", "key": ""},
            "http_unistat": {"listen_address": "localhost", "port": self.unistat_port},
            "logger": {
                "file": yc.output_path("common.log"),
            },
            "service": {
                "common": {
                    "access_log": {
                        "file": yc.output_path("access.log"),
                        "disable_printing_level": True,
                    },
                    "modification_log": {
                        "file": yc.output_path("modification.log"),
                    },
                },
                "tvm": {
                    "self_tvm_id": 1000501,
                    "secret_filepath": tvm_secret_path,
                    "disk_cache_dir": tvm_cache_dir,
                    "check_service_tickets": True,
                    "blackbox_env": "prod_yateam",
                    "roles_for_idm_slug": "yasms_internal_test",
                    "disable_src_check": True,
                    "disable_default_uid_check": True,
                    "destinations": {
                        "yt": 1000502,
                        "blackbox": 1000503,
                    },
                    "tvm_host": "http://127.0.0.1",
                    "tvm_port": tvmapi_port,
                    "tirole_host": "http://127.0.0.1",
                    "tirole_port": tirole_port,
                    "tirole_tvm_id": 1000001,
                },
                "processor": {
                    "reader": {
                        "driver": "mysql",
                        "mysql_config": {
                            "host": "localhost",
                            "port": self.mysql_port,
                            "user": mysql_user_path,
                            "password": mysql_password_path,
                            "db": "sms",
                        },
                    },
                    "writer": {
                        "driver": "mysql",
                        "mysql_config": {
                            "host": "localhost",
                            "port": self.mysql_port,
                            "user": mysql_user_path,
                            "password": mysql_password_path,
                            "db": "sms",
                        },
                    },
                    "regions": {
                        "driver": "yt",
                        "yt_config": {
                            "cluster": os.environ["YT_PROXY"],
                            "dir": "//home",
                            "timeout_ms": 30000,
                        },
                    },
                    "cache_dir": self.cache_dir,
                    "update_interval": "24h",
                    "update_warning_threshold": "24h",
                },
                "blackbox": {
                    "url": blackbox_address,
                    "timeout": "100ms",
                    "retries": 1,
                },
            },
        }

        with open(config_path, 'w') as f:
            json.dump(yasms_internal_config, f, indent=2)

        self._process_pid = None
        self._start_daemon_command = [
            yc.build_path('passport/infra/daemons/yasms_internal/cmd/yasms_internal'),
            '-c',
            config_path,
        ]

        self.reset_mysql()
        self.reset_yt()

        self.restart_daemon()

    def stop(self):
        self.stop_daemon()
        self._blackbox_process.terminate()
        self._pm.release()

    def stop_daemon(self):
        if self._process_pid is not None:
            stop_daemon(self._process_pid)
            self._process_pid = None

    def restart_daemon(self):
        self.stop_daemon()
        self._process_pid = start_daemon(self._start_daemon_command, os.environ.copy(), self.http_port, 300).pid

    def reset_mysql(self):
        p = subprocess.Popen(
            [
                os.path.join(os.environ.get('RECIPE_MYSQL_DIR'), 'mysql'),
                '-u',
                'root',
                '-h',
                '127.0.0.1',
                '-P',
                str(self.mysql_port),
                '-e',
                'source '
                + os.path.join(
                    yc.source_path('passport/infra/daemons/yasms_internal/internal/model/mysql/gotest/sms.sql')
                ),
            ],
            stderr=subprocess.PIPE,
            stdout=subprocess.PIPE,
        )
        print('----------')
        print('clearing database: ', p.communicate())
        print('----------')

    @staticmethod
    def reset_yt():
        delete_table(REGIONS_TABLE_NAME)

    def get_audit_log(self, table_name, id_field):
        audit_bulk = []
        audit_row = []
        data_row = []

        db = MySQLdb.connect(host='127.0.0.1', port=self.mysql_port, user='root', password='', database='sms')
        c = db.cursor()
        c.execute('select bulk_id, author, issue, comment from sms.audit_bulk')
        for (bulk_id, author, issue, comment) in c:
            audit_bulk.append((bulk_id, author, issue, comment))

        c.execute('select row_id, bulk_id, table_name, type, payload, entity_id from sms.audit_row')
        for (row_id, bulk_id, name, type, payload, entity_id) in c:
            audit_row.append((row_id, bulk_id, name, type, payload, entity_id))

        c.execute('select {}, event_create, event_modify from {}'.format(id_field, table_name))
        for (id, event_create, event_modify) in c:
            data_row.append((id, event_create, event_modify))

        return audit_bulk, audit_row, data_row


def make_gate_with_id(gate_id: str, i: str):
    return {
        "gateid": gate_id,
        "aliase": "alias-{}".format(i),
        "fromname": "fromname-{}".format(i),
        "contractor": "contractor-{}".format(i),
        "consumer": "consumer-{}".format(i),
        "extra": {
            "extra": "extra-{}".format(i),
        },
    }
